/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import org.apache.log4j.Logger;

class ProcessManagerFactory {
    private static Logger eLog = LogManager.getEngineLogger();
    private static ProcessManagerFactory singleton;
    private Map processManagers = new Hashtable();

    static void create() throws Exception {
        try {
            singleton = new ProcessManagerFactory();
            singleton.init();
        }
        catch (Exception ex) {
            String E0112 = StringManager.get("E0112");
            eLog.error((Object)E0112);
            throw ex;
        }
    }

    static ProcessManagerFactory getInstance() {
        return singleton;
    }

    private ProcessManagerFactory() {
    }

    private void init() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ProcessManager getProcessManager(String pdid) throws InvalidProcessDefinitionException {
        ProcessManager pm = (ProcessManager)this.processManagers.get(pdid);
        if (pm == null) {
            Map map = this.processManagers;
            synchronized (map) {
                pm = new ProcessManager(pdid);
                this.processManagers.put(pdid, pm);
            }
        }
        return pm;
    }

    public synchronized ProcessManager getOwnerProcessManager(String pid) throws InvalidProcessInstanceException {
        try {
            ProcessManager pm = null;
            Iterator it = this.processManagers.keySet().iterator();
            while (it.hasNext()) {
                pm = (ProcessManager)this.processManagers.get(it.next());
                if (!pm.isMemberOfProcess(pid)) continue;
                return pm;
            }
            pm = this.createOwnerProcessManager(pid);
            return pm;
        }
        catch (InvalidProcessInstanceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0163 = StringManager.get("E0163") + "(ProcessID = " + pid + ")";
            throw new InvalidProcessInstanceException(E0163, ex);
        }
    }

    Process[] getProcesses(Filter filter) throws InvalidFilterException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            Process[] beans = procDAO.findByFilter(filter);
            return beans;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0151 = StringManager.get("E0151");
            throw new InvalidFilterException(E0151, ex);
        }
    }

    Activity[] getActivities(Filter filter) throws InvalidFilterException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ActivityDAO actDAO = daoFactory.getActivityDAO();
            Activity[] beans = actDAO.findByFilter(filter);
            return beans;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0124 = StringManager.get("E0124");
            throw new InvalidFilterException(E0124, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessManager createOwnerProcessManager(String pid) throws InvalidProcessInstanceException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            ProcessBean bean = procDAO.findByPrimaryKey(pid);
            if (bean == null) {
                String E0164 = StringManager.get("E0164") + "(ProcessID = " + pid + ")";
                throw new InvalidProcessInstanceException(E0164);
            }
            ProcessManager pm = new ProcessManager(bean.getProcDefinitionID());
            if (pm == null) {
                String E0165 = StringManager.get("E0165") + "(ProcessID = " + pid + ")";
                throw new InvalidProcessInstanceException(E0165);
            }
            Map map = this.processManagers;
            synchronized (map) {
                this.processManagers.put(bean.getProcDefinitionID(), pm);
            }
            return pm;
        }
        catch (InvalidProcessInstanceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0149 = StringManager.get("E0149") + "(ProcessID = " + pid + ")";
            throw new InvalidProcessInstanceException(E0149, ex);
        }
    }
}

