/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ParticipantImpl;
import jp.co.argo21.nautica.workflow.engine.ResourceInternal;
import jp.co.argo21.nautica.workflow.engine.ResourceManagerFactory;
import jp.co.argo21.nautica.workflow.omg.InvalidResourceException;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfAssignment;
import jp.co.argo21.nautica.workflow.omg.WfResource;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.ParticipantHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;
import org.apache.log4j.Logger;

public class WorkItemInternal
implements WfAssignment {
    private static final long serialVersionUID = 20050000000000001L;
    private static Logger eLog = LogManager.getEngineLogger();
    private WorkItem workItem;

    public WorkItemInternal(WorkItem item) {
        this.workItem = item;
    }

    public WfActivity getActivity() throws WorkflowException {
        try {
            String pid = this.workItem.getProcessID();
            String aid = this.workItem.getActivityID();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ActivityDAO activityDAO = daoFactory.getActivityDAO();
            ActivityBean bean = activityDAO.findByPrimaryKey(pid, aid);
            ActivityInternal act = new ActivityInternal(bean);
            return act;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0124 = StringManager.get("E0124");
            throw new WorkflowException(E0124, ex);
        }
    }

    public WfResource getAssignee() throws WorkflowException {
        try {
            Participant part = null;
            int ptype = this.workItem.getParticipantType();
            String pname = this.workItem.getParticipantName();
            ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
            if (ptype == 5) {
                UserManager um = rmf.getUserManager();
                User user = um.getUser(pname);
                part = ParticipantHelper.narrow(user);
            } else if (ptype == 4) {
                OrganizationManager om = rmf.getOrganizationManager();
                Organization org = om.getOrganization(pname);
                part = ParticipantHelper.narrow(org);
            } else if (ptype == 3) {
                RoleManager rm = rmf.getRoleManager();
                Role role = rm.getRole(pname);
                part = ParticipantHelper.narrow(role);
            } else {
                String E0143 = StringManager.get("E0143");
                throw new WorkflowException(E0143);
            }
            if (part == null) {
                String E0145 = StringManager.get("E0145");
                throw new WorkflowException(E0145);
            }
            ResourceInternal ret = new ResourceInternal(part);
            return ret;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0141 = StringManager.get("E0141");
            throw new WorkflowException(E0141, ex);
        }
    }

    public void setAssignee(WfResource value) throws InvalidResourceException, WorkflowException {
        try {
            if (value == null || !(value instanceof ResourceInternal)) {
                String E0144 = StringManager.get("E0144");
                throw new InvalidResourceException(E0144);
            }
            ResourceInternal rsc = (ResourceInternal)value;
            Participant part = rsc.getParticipant();
            if (part == null) {
                String E0145 = StringManager.get("E0145");
                throw new InvalidResourceException(E0145);
            }
            int sparttype = this.workItem.getParticipantType();
            String spartid = this.workItem.getParticipantName();
            ParticipantImpl src = new ParticipantImpl(spartid, "", sparttype);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();
            workItemDAO.updateParticipant(this.workItem.getID(), src, part);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0142 = StringManager.get("E0142");
            throw new WorkflowException(E0142, ex);
        }
    }

    WorkItem getWorkItem() {
        return this.workItem;
    }
}

