/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.engine.AuditDataRecord;
import jp.co.argo21.nautica.workflow.engine.AuditPrefix;
import jp.co.argo21.nautica.workflow.engine.AuditSuffix;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.engine.SessionManagerFactory;
import jp.co.argo21.nautica.workflow.engine.SystemChecker;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityNameException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler;
import org.apache.log4j.Logger;

public class WorkflowAdminHandlerImpl
implements WorkflowAdminHandler {
    private static Logger eLog = LogManager.getEngineLogger();
    private static Logger audit = LogManager.getAuditLogger();

    WorkflowAdminHandlerImpl() {
    }

    public void changeProcessesState(String session, String pdid, Filter filter, ProcessState state) throws InvalidSessionException, InvalidProcessDefinitionException, InvalidFilterException, InvalidStateException, TransitionNotAllowedException {
        String argInfo = "(NAUTICA API = changeProcessesState,session = [" + session + "]," + "pdid = [" + pdid + "]," + "filter = [" + filter + "]," + "state = [" + state + "])";
        try {
            this.checkProcessDefinitionID(pdid);
            if (filter == null) {
                String msg = StringManager.get("E0060");
                throw new InvalidFilterException(msg);
            }
            if (state == null) {
                String msg = StringManager.get("E0063");
                throw new InvalidStateException(msg);
            }
            if (ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
                String msg = StringManager.get("E0064");
                throw new InvalidStateException(msg);
            }
            if (ProcessState.CLOSED_COMPLETED.equals(state)) {
                String msg = StringManager.get("E0065");
                throw new InvalidStateException(msg);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getProcessManager(pdid);
            pm.changeProcessesState(filter, state);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMChangedProcessInstanceState", session), new AuditSuffix());
            data.setDataElement("NewProcessState", state);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessDefinitionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidStateException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0156 = StringManager.get("E0156") + argInfo;
            eLog.error((Object)E0156, (Throwable)ex);
            throw new TransitionNotAllowedException(E0156, ex);
        }
    }

    public void changeActivitiesState(String session, String pdid, String adid, Filter filter, ActivityState state) throws InvalidSessionException, InvalidProcessDefinitionException, InvalidActivityNameException, InvalidFilterException, InvalidStateException, TransitionNotAllowedException {
        String argInfo = "(NAUTICA API = changeActivitiesState,session = [" + session + "]," + "pdid = [" + pdid + "]," + "adid = [" + adid + "]," + "filter = [" + filter + "]," + "state = [" + state + "])";
        try {
            this.checkProcessDefinitionID(pdid);
            this.checkActivityDefinitionID(adid);
            if (filter == null) {
                String msg = StringManager.get("E0060");
                throw new InvalidFilterException(msg);
            }
            if (state == null) {
                String msg = StringManager.get("E0066");
                throw new InvalidStateException(msg);
            }
            if (ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
                String msg = StringManager.get("E0067");
                throw new InvalidStateException(msg);
            }
            if (ActivityState.CLOSED_COMPLETED.equals(state)) {
                String msg = StringManager.get("E0068");
                throw new InvalidStateException(msg);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getProcessManager(pdid);
            pm.changeActivitiesState(adid, filter, state);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMChangedActivityInstanceState", session), new AuditSuffix());
            data.setDataElement("NewActivityState", state);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessDefinitionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidActivityNameException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidStateException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0157 = StringManager.get("E0157") + argInfo;
            eLog.error((Object)E0157, (Throwable)ex);
            throw new TransitionNotAllowedException(E0157, ex);
        }
    }

    public void terminateProcesses(String session, String pdid, Filter filter) throws InvalidSessionException, InvalidProcessDefinitionException, InvalidFilterException {
        String argInfo = "(NAUTICA API = terminateProcesses,session = [" + session + "]," + "pdid = [" + pdid + "]," + "filter = [" + filter + "])";
        try {
            this.checkProcessDefinitionID(pdid);
            if (filter == null) {
                String msg = StringManager.get("E0060");
                throw new InvalidFilterException(msg);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getProcessManager(pdid);
            pm.terminateProcesses(filter);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMTerminatedProcessInstance", session), new AuditSuffix());
            data.setDataElement("NewProcessState", ProcessState.CLOSED_TERMINATED);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessDefinitionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0136 = StringManager.get("E0136") + argInfo;
            eLog.error((Object)E0136, (Throwable)ex);
            throw new InvalidFilterException(E0136, ex);
        }
    }

    public void assignProcessesAttribute(String session, String pdid, Filter filter, Attribute attr) throws InvalidSessionException, InvalidProcessDefinitionException, InvalidFilterException, InvalidAttributeException {
        String argInfo = "(NAUTICA API = assignProcessesAttribute,session = [" + session + "]," + "pdid = [" + pdid + "]," + "filter = [" + filter + "]," + "attr = [" + attr + "])";
        try {
            this.checkProcessDefinitionID(pdid);
            if (filter == null) {
                String E0060 = StringManager.get("E0060");
                throw new InvalidFilterException(E0060);
            }
            if (attr == null) {
                String E0131 = StringManager.get("E0131");
                throw new InvalidAttributeException(E0131);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getProcessManager(pdid);
            pm.assignProcessesAttribute(filter, attr);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMAssignedProcessInstanceAttributes", session), new AuditSuffix());
            data.setDataElement("AttributeName", attr.getName());
            data.setDataElement("AttributeType", attr.getType());
            data.setDataElement("NewAttributeValue", attr.getValue());
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessDefinitionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0080 = StringManager.get("E0080") + argInfo;
            eLog.error((Object)E0080, (Throwable)ex);
            throw new InvalidFilterException(E0080, ex);
        }
    }

    public void assignActivitiesAttribute(String session, String pdid, String adid, Filter filter, Attribute attr) throws InvalidSessionException, InvalidProcessDefinitionException, InvalidActivityNameException, InvalidFilterException, InvalidAttributeException {
        String argInfo = "(NAUTICA API = assignActivitiesAttribute,session = [" + session + "]," + "pdid = [" + pdid + "]," + "adid = [" + adid + "]," + "filter = [" + filter + "]," + "attr = [" + attr + "])";
        try {
            this.checkProcessDefinitionID(pdid);
            this.checkActivityDefinitionID(adid);
            if (filter == null) {
                String msg = StringManager.get("E0060");
                throw new InvalidFilterException(msg);
            }
            if (attr == null) {
                String E0131 = StringManager.get("E0131");
                throw new InvalidAttributeException(E0131);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getProcessManager(pdid);
            pm.assignActivitiesAttribute(adid, filter, attr);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMAssignedActivityInstanceAttributes", session), new AuditSuffix());
            data.setDataElement("AttributeName", attr.getName());
            data.setDataElement("AttributeType", attr.getType());
            data.setDataElement("NewAttributeValue", attr.getValue());
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessDefinitionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidActivityNameException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0158 = StringManager.get("E0158") + argInfo;
            eLog.error((Object)E0158, (Throwable)ex);
            throw new InvalidAttributeException(E0158, ex);
        }
    }

    public void abortProcesses(String session, String pdid, Filter filter) throws InvalidSessionException, InvalidProcessDefinitionException, InvalidFilterException {
        String argInfo = "(NAUTICA API = abortProcesses,session = [" + session + "]," + "pdid = [" + pdid + "]," + "filter = [" + filter + "])";
        try {
            this.checkProcessDefinitionID(pdid);
            if (filter == null) {
                String msg = StringManager.get("E0060");
                throw new InvalidFilterException(msg);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getProcessManager(pdid);
            pm.abortProcesses(filter);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMAbortedProcessInstance", session), new AuditSuffix());
            data.setDataElement("NewProcessState", ProcessState.CLOSED_ABORTED);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessDefinitionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            String E0137 = StringManager.get("E0137") + argInfo;
            eLog.error((Object)E0137, (Throwable)ex);
            throw new InvalidFilterException(E0137, ex);
        }
    }

    public void abortProcess(String session, String pid) throws InvalidSessionException, InvalidProcessInstanceException {
        String argInfo = "(NAUTICA API = abortProcesses,session = [" + session + "]," + "pid = [" + pid + "])";
        try {
            if (pid == null || pid.trim().equals("")) {
                String E0189 = StringManager.get("E0189");
                throw new InvalidProcessInstanceException(E0189);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
            proc.abort();
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix(pid, "WMAbortedProcessInstance", session), new AuditSuffix());
            data.setDataElement("NewProcessState", ProcessState.CLOSED_ABORTED);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0137 = StringManager.get("E0137") + argInfo;
            eLog.error((Object)E0137, (Throwable)ex);
            throw new InvalidProcessInstanceException(E0137, ex);
        }
    }

    private void rollbackAndLogging(Exception ex, String argInfo) {
        try {
            DataAccessManager.rollback();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        String msg = ex.getMessage() + argInfo;
        eLog.error((Object)msg, (Throwable)ex);
    }

    private void checkProcessDefinitionID(String pdid) throws InvalidProcessDefinitionException {
        if (pdid == null || pdid.trim().equals("")) {
            String E0188 = StringManager.get("E0188");
            throw new InvalidProcessDefinitionException(E0188);
        }
    }

    private void checkActivityDefinitionID(String adid) throws InvalidActivityNameException {
        if (adid == null || adid.trim().equals("")) {
            String E0190 = StringManager.get("E0190");
            throw new InvalidActivityNameException(E0190);
        }
    }

    private void validateSession(String session) throws InvalidSessionException {
        if (session == null || session.trim().equals("")) {
            String E0170 = StringManager.get("E0170");
            throw new InvalidSessionException(E0170);
        }
        SessionManagerFactory factory = SessionManagerFactory.getInstance();
        SessionManager manager = factory.getSessionManager();
        manager.validateSession(session);
        User user = manager.getSessionUser(session);
        if (user == null) {
            String msg = StringManager.get("E0061");
            throw new InvalidSessionException(msg);
        }
        try {
            String uid = user.getID();
            SystemChecker.checkAdmin(uid);
        }
        catch (Exception ex) {
            String msg = StringManager.get("E0062");
            throw new InvalidSessionException(msg);
        }
    }
}

