/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.jms.MessagingException;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class WorkflowMQ {
    private static Logger eLog = LogManager.getEngineLogger();
    private static final boolean RECEIVE_TRANSACTION = false;
    private static final int RECEIVE_ACKNOWLEDGE_MODE = 1;
    private static final boolean SEND_TRANSACTION = true;
    private static final int SEND_ACKNOWLEDGE_MODE = 0;
    private QueueConnectionFactory factory;
    private QueueConnection receiveConnection;
    private QueueSession receiveSession;
    private QueueReceiver receiver;
    private Queue queue;

    public WorkflowMQ(QueueConnectionFactory factory, String name, WorkflowMessageAdapter adapter) throws MessagingException {
        try {
            this.factory = factory;
            this.receiveConnection = factory.createQueueConnection();
            this.receiveConnection.setClientID(this.toString());
            this.receiveSession = this.receiveConnection.createQueueSession(false, 1);
            this.queue = this.receiveSession.createQueue(name);
            this.receiver = this.receiveSession.createReceiver(this.queue);
            this.receiver.setMessageListener((MessageListener)adapter);
        }
        catch (JMSException ex) {
            if (this.receiver != null) {
                try {
                    this.receiver.close();
                }
                catch (JMSException ex2) {
                    // empty catch block
                }
            }
            if (this.receiveSession != null) {
                try {
                    this.receiveSession.close();
                }
                catch (JMSException ex2) {
                    // empty catch block
                }
            }
            if (this.receiveConnection != null) {
                try {
                    this.receiveConnection.close();
                }
                catch (JMSException ex2) {
                    // empty catch block
                }
            }
            String errMsg = StringManager.get("E0048");
            eLog.error((Object)errMsg, (Throwable)ex);
            throw new MessagingException(errMsg, ex);
        }
    }

    public String getQueueName() throws MessagingException {
        try {
            return this.queue.getQueueName();
        }
        catch (JMSException ex) {
            String errMsg = StringManager.get("E0041");
            eLog.error((Object)errMsg, (Throwable)ex);
            throw new MessagingException(errMsg, ex);
        }
    }

    public void start() throws MessagingException {
        try {
            this.receiveConnection.start();
        }
        catch (JMSException ex) {
            String errMsg = StringManager.get("E0046");
            eLog.error((Object)errMsg, (Throwable)ex);
            throw new MessagingException(errMsg, ex);
        }
    }

    public void stop() throws MessagingException {
        try {
            this.receiveConnection.stop();
        }
        catch (JMSException ex) {
            String errMsg = StringManager.get("E0047");
            eLog.error((Object)errMsg, (Throwable)ex);
            throw new MessagingException(errMsg, ex);
        }
    }

    public void shutdown() {
        String errMsg;
        if (this.receiver != null) {
            try {
                this.receiver.close();
            }
            catch (JMSException ex) {
                errMsg = StringManager.get("E0043");
                eLog.error((Object)errMsg, (Throwable)ex);
            }
        }
        if (this.receiveSession != null) {
            try {
                this.receiveSession.close();
            }
            catch (JMSException ex) {
                errMsg = StringManager.get("E0044");
                eLog.error((Object)errMsg, (Throwable)ex);
            }
        }
        if (this.receiveConnection != null) {
            try {
                this.receiveConnection.close();
            }
            catch (JMSException ex) {
                errMsg = StringManager.get("E0045");
                eLog.error((Object)errMsg, (Throwable)ex);
            }
        }
    }

    /*
     * Loose catch block
     */
    public void send(WorkflowMessage message) throws MessagingException {
        block23: {
            JMSException ex2222;
            QueueSender sender;
            QueueSession session;
            QueueConnection con;
            block21: {
                con = null;
                session = null;
                sender = null;
                con = this.factory.createQueueConnection();
                con.start();
                session = con.createQueueSession(true, 0);
                sender = session.createSender(this.queue);
                sender.setDeliveryMode(2);
                ObjectMessage om = session.createObjectMessage((Serializable)message);
                sender.send((Message)om);
                session.commit();
                Object var8_7 = null;
                if (sender == null) break block21;
                try {
                    sender.close();
                }
                catch (JMSException ex2222) {
                    // empty catch block
                }
            }
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException ex2222) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (JMSException ex2222) {}
            }
            break block23;
            {
                catch (JMSException ex3) {
                    if (session != null) {
                        try {
                            session.rollback();
                        }
                        catch (JMSException ex2) {
                            // empty catch block
                        }
                    }
                    String errMsg = StringManager.get("E0042");
                    eLog.error((Object)errMsg, (Throwable)ex3);
                    throw new MessagingException(errMsg, ex3);
                }
            }
            catch (Throwable throwable) {
                JMSException ex2222;
                Object var8_8 = null;
                if (sender != null) {
                    try {
                        sender.close();
                    }
                    catch (JMSException ex2222) {
                        // empty catch block
                    }
                }
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (JMSException ex2222) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (JMSException ex2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

