/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.activeio.Disposable;
import org.activeio.net.SocketMetadata;
import org.activeio.packet.ByteBufferPacket;

public class NIOBaseChannel
implements SocketMetadata,
Disposable {
    protected final SocketChannel socketChannel;
    protected final Socket socket;
    private final boolean useDirect;
    private int curentSoTimeout;
    private boolean disposed;
    private final String name;

    protected NIOBaseChannel(SocketChannel socketChannel, boolean useDirect) throws IOException {
        this.socketChannel = socketChannel;
        this.useDirect = useDirect;
        this.socket = this.socketChannel.socket();
        if (useDirect) {
            this.socket.setSendBufferSize(ByteBufferPacket.DEFAULT_DIRECT_BUFFER_SIZE);
            this.socket.setReceiveBufferSize(ByteBufferPacket.DEFAULT_DIRECT_BUFFER_SIZE);
        } else {
            this.socket.setSendBufferSize(ByteBufferPacket.DEFAULT_BUFFER_SIZE);
            this.socket.setReceiveBufferSize(ByteBufferPacket.DEFAULT_BUFFER_SIZE);
        }
        this.name = "NIO Socket Connection: " + this.getLocalSocketAddress() + " -> " + this.getRemoteSocketAddress();
    }

    protected ByteBuffer allocateBuffer() {
        if (this.useDirect) {
            return ByteBuffer.allocateDirect(ByteBufferPacket.DEFAULT_DIRECT_BUFFER_SIZE);
        }
        return ByteBuffer.allocate(ByteBufferPacket.DEFAULT_BUFFER_SIZE);
    }

    protected void setSoTimeout(int i) throws SocketException {
        if (this.curentSoTimeout != i) {
            this.socket.setSoTimeout(i);
            this.curentSoTimeout = i;
        }
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.disposed = true;
    }

    public void flush() throws IOException {
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }
}

