/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.activeio.Packet;
import org.activeio.SynchChannel;
import org.activeio.net.SocketMetadata;
import org.activeio.packet.ByteArrayPacket;
import org.activeio.packet.EOSPacket;
import org.activeio.packet.EmptyPacket;

public class SocketSynchChannel
implements SynchChannel,
SocketMetadata {
    protected static final int DEFAULT_BUFFER_SIZE = 65536;
    private final Socket socket;
    private final OutputStream out;
    private final InputStream in;
    private boolean disposed;
    private int curentSoTimeout;
    private Packet inputPacket;

    protected SocketSynchChannel(Socket socket) throws IOException {
        this.socket = socket;
        socket.setReceiveBufferSize(65536);
        socket.setSendBufferSize(65536);
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
    }

    public Packet read(long timeout) throws IOException {
        try {
            Packet.ByteSequence sequence;
            int size;
            if (timeout == -1L) {
                this.setSoTimeout(0);
            } else if (timeout == 0L) {
                this.setSoTimeout(1);
            } else {
                this.setSoTimeout((int)timeout);
            }
            if (this.inputPacket == null || !this.inputPacket.hasRemaining()) {
                this.inputPacket = this.allocatePacket();
            }
            if ((size = this.in.read((sequence = this.inputPacket.asByteSequence()).getData(), sequence.getOffset(), sequence.getLength())) == -1) {
                return EOSPacket.EOS_PACKET;
            }
            if (size == 0) {
                return EmptyPacket.EMPTY_PACKET;
            }
            this.inputPacket.position(size);
            Packet remaining = this.inputPacket.slice();
            this.inputPacket.flip();
            Packet data = this.inputPacket.slice();
            this.inputPacket = remaining;
            return data;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
    }

    private Packet allocatePacket() {
        return new ByteArrayPacket(new byte[65536]);
    }

    protected void setSoTimeout(int i) throws SocketException {
        if (this.curentSoTimeout != i) {
            this.socket.setSoTimeout(i);
            this.curentSoTimeout = i;
        }
    }

    public void write(Packet packet) throws IOException {
        packet.writeTo(this.out);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        try {
            this.out.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.disposed = true;
    }

    public void start() throws IOException {
    }

    public void stop(long timeout) throws IOException {
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return "Socket Connection: " + this.getLocalSocketAddress() + " -> " + this.getRemoteSocketAddress();
    }
}

