/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.activeio.SynchChannel;
import org.activeio.SynchChannelFactory;
import org.activeio.SynchChannelServer;
import org.activeio.net.SocketSynchChannel;
import org.activeio.net.SocketSynchChannelServer;
import org.activeio.net.URISupport;

public class SocketSynchChannelFactory
implements SynchChannelFactory {
    protected static final int DEFAULT_BACKLOG = 500;
    private final SocketFactory socketFactory;
    private final ServerSocketFactory serverSocketFactory;
    private int backlog = 500;

    public SocketSynchChannelFactory() {
        this(SocketFactory.getDefault(), ServerSocketFactory.getDefault());
    }

    public SocketSynchChannelFactory(SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        this.socketFactory = socketFactory;
        this.serverSocketFactory = serverSocketFactory;
    }

    public SynchChannel openSynchChannel(URI location) throws IOException {
        Socket socket = null;
        socket = this.socketFactory.createSocket(location.getHost(), location.getPort());
        return this.createSynchChannel(socket);
    }

    protected SynchChannel createSynchChannel(Socket socket) throws IOException {
        return new SocketSynchChannel(socket);
    }

    public SynchChannelServer bindSynchChannel(URI bindURI) throws IOException {
        String host = bindURI.getHost();
        InetAddress addr = host == null || host.length() == 0 || host.equals("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(host);
        ServerSocket serverSocket = addr.equals(InetAddress.getLocalHost()) ? this.serverSocketFactory.createServerSocket(bindURI.getPort(), this.backlog) : this.serverSocketFactory.createServerSocket(bindURI.getPort(), this.backlog, addr);
        URI connectURI = bindURI;
        try {
            connectURI = URISupport.changeHost(connectURI, addr.getHostName());
            connectURI = URISupport.changePort(connectURI, serverSocket.getLocalPort());
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException("Could build connect URI: " + e).initCause(e);
        }
        return new SocketSynchChannelServer(serverSocket, bindURI, connectURI);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

