/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelFactory;
import org.activeio.AsynchChannelListener;
import org.activeio.AsynchChannelServer;
import org.activeio.Packet;
import org.activeio.net.VMPipeAsynchChannelServer;

public final class VMPipeAsynchChannelFactory
implements AsynchChannelFactory {
    private static final String SERVER_MAP_LOCATION = VMPipeAsynchChannelFactory.class.getName() + ".SERVER_MAP";
    private static final Map SERVER_MAP;
    private static final ClassLoader MY_CLASSLOADER;
    private boolean forceRefelection;
    static /* synthetic */ Class class$org$activeio$AsynchChannelListener;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public AsynchChannel openAsynchChannel(URI location) throws IOException {
        Object server = VMPipeAsynchChannelFactory.lookupServer(location);
        if (!this.forceRefelection && server.getClass() == VMPipeAsynchChannelServer.class) {
            return ((VMPipeAsynchChannelServer)server).connect();
        }
        try {
            Method method = server.getClass().getMethod("connect", new Class[0]);
            Object channel = method.invoke(server, new Object[0]);
            return new ClassloaderAsynchChannelAdapter(channel);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Connection could not be established: " + e).initCause(e);
        }
    }

    public AsynchChannelServer bindAsynchChannel(URI bindURI) throws IOException {
        VMPipeAsynchChannelServer server = new VMPipeAsynchChannelServer(bindURI);
        VMPipeAsynchChannelFactory.bindServer(bindURI, server);
        return server;
    }

    private static Map getServerMap() {
        return SERVER_MAP;
    }

    public static String getServerKeyForURI(URI location) {
        return location.getHost();
    }

    public static void bindServer(URI bindURI, VMPipeAsynchChannelServer server) throws IOException {
        String key = VMPipeAsynchChannelFactory.getServerKeyForURI(bindURI);
        if (VMPipeAsynchChannelFactory.getServerMap().get(key) != null) {
            throw new IOException("Server is allready bound at: " + bindURI);
        }
        VMPipeAsynchChannelFactory.getServerMap().put(key, server);
    }

    public static Object lookupServer(URI location) throws IOException {
        String key = VMPipeAsynchChannelFactory.getServerKeyForURI(location);
        Object server = VMPipeAsynchChannelFactory.getServerMap().get(key);
        if (server == null) {
            throw new IOException("Connection refused.");
        }
        return server;
    }

    public static void unbindServer(URI bindURI) {
        String key = VMPipeAsynchChannelFactory.getServerKeyForURI(bindURI);
        VMPipeAsynchChannelFactory.getServerMap().remove(key);
    }

    public boolean isForceRefelection() {
        return this.forceRefelection;
    }

    public void setForceRefelection(boolean forceRefelection) {
        this.forceRefelection = forceRefelection;
    }

    static {
        Map m = null;
        m = (Map)System.getProperties().get(SERVER_MAP_LOCATION);
        if (m == null) {
            m = Collections.synchronizedMap(new HashMap());
            System.getProperties().put(SERVER_MAP_LOCATION, m);
        }
        SERVER_MAP = m;
        MY_CLASSLOADER = Packet.class.getClassLoader();
    }

    public static class ClassloaderAsynchChannelAdapter
    implements AsynchChannel {
        private final ClassLoader cl;
        private final Object channel;
        private final Method writeMethod;
        private final Method setListenerMethod;
        private final Class listenerClazz;
        private final Class packetClazz;
        private final Object listenerProxy;
        private final Method duplicateMethod;
        private final Method startMethod;
        private final Method stopMethod;
        private final Method disposeMethod;
        private AsynchChannelListener channelListener;

        public ClassloaderAsynchChannelAdapter(Object channel) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
            this.channel = channel;
            Class<?> clazz = channel.getClass();
            this.cl = clazz.getClassLoader();
            this.listenerClazz = this.cl.loadClass((class$org$activeio$AsynchChannelListener == null ? (class$org$activeio$AsynchChannelListener = VMPipeAsynchChannelFactory.class$("org.activeio.AsynchChannelListener")) : class$org$activeio$AsynchChannelListener).getName());
            this.packetClazz = this.cl.loadClass((class$org$activeio$Packet == null ? (class$org$activeio$Packet = VMPipeAsynchChannelFactory.class$("org.activeio.Packet")) : class$org$activeio$Packet).getName());
            this.writeMethod = clazz.getMethod("write", this.packetClazz);
            this.startMethod = clazz.getMethod("start", new Class[0]);
            this.stopMethod = clazz.getMethod("stop", Long.TYPE);
            this.disposeMethod = clazz.getMethod("dispose", new Class[0]);
            this.setListenerMethod = clazz.getMethod("setAsynchChannelListener", this.listenerClazz);
            this.duplicateMethod = this.packetClazz.getMethod("duplicate", class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = VMPipeAsynchChannelFactory.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            ListenerProxyHandler handler = new ListenerProxyHandler();
            this.listenerProxy = Proxy.newProxyInstance(this.cl, new Class[]{this.listenerClazz}, (InvocationHandler)handler);
        }

        public void write(Packet packet) throws IOException {
            this.callIOExceptionMethod(this.writeMethod, new Object[]{packet.duplicate(this.cl)});
        }

        public void setAsynchChannelListener(AsynchChannelListener channelListener) {
            this.channelListener = channelListener;
            this.callMethod(this.setListenerMethod, new Object[]{channelListener == null ? null : this.listenerProxy});
        }

        public AsynchChannelListener getAsynchChannelListener() {
            return this.channelListener;
        }

        public void dispose() {
            this.callMethod(this.disposeMethod, new Object[0]);
        }

        public void start() throws IOException {
            this.callIOExceptionMethod(this.startMethod, new Object[0]);
        }

        public void stop(long timeout) throws IOException {
            this.callIOExceptionMethod(this.stopMethod, new Object[]{new Long(timeout)});
        }

        private void callMethod(Method method, Object[] args) {
            try {
                method.invoke(this.channel, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(e.getTargetException());
            }
            catch (Throwable e) {
                throw new RuntimeException("Reflexive invocation failed: " + e, e);
            }
        }

        private void callIOExceptionMethod(Method method, Object[] args) throws IOException {
            try {
                method.invoke(this.channel, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof IOException) {
                    throw (IOException)e.getTargetException();
                }
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(e.getTargetException());
            }
            catch (Throwable e) {
                throw (IOException)new IOException("Reflexive invocation failed: " + e).initCause(e);
            }
        }

        public Object narrow(Class target) {
            if (target.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        public void flush() throws IOException {
        }

        public class ListenerProxyHandler
        implements InvocationHandler {
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                switch (method.getName().length()) {
                    case 8: {
                        Object packet = ClassloaderAsynchChannelAdapter.this.duplicateMethod.invoke(args[0], MY_CLASSLOADER);
                        ClassloaderAsynchChannelAdapter.this.channelListener.onPacket((Packet)packet);
                        break;
                    }
                    case 13: {
                        ClassloaderAsynchChannelAdapter.this.channelListener.onPacketError((IOException)args[0]);
                        break;
                    }
                    default: {
                        ClassloaderAsynchChannelAdapter.this.channelListener.onPacketError(new IOException("Unknown proxy method invocation: " + method.getName()));
                    }
                }
                return null;
            }
        }
    }
}

