/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.URI;
import org.activeio.AcceptListener;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelServer;
import org.activeio.net.VMPipeAsynchChannelFactory;
import org.activeio.net.VMPipeAsynchChannelPipe;

public final class VMPipeAsynchChannelServer
implements AsynchChannelServer {
    private final URI bindURI;
    private final URI connectURI;
    private AcceptListener acceptListener;
    private boolean disposed;

    public VMPipeAsynchChannelServer(URI bindURI) {
        this.bindURI = this.connectURI = bindURI;
    }

    public URI getBindURI() {
        return this.bindURI;
    }

    public URI getConnectURI() {
        return this.connectURI;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        VMPipeAsynchChannelFactory.unbindServer(this.bindURI);
        this.disposed = true;
    }

    public void start() throws IOException {
        if (this.acceptListener == null) {
            throw new IOException("acceptListener has not been set.");
        }
    }

    public void stop(long timeout) {
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return "VM Pipe Server: " + this.getConnectURI();
    }

    public void setAcceptListener(AcceptListener acceptListener) {
        this.acceptListener = acceptListener;
    }

    public AsynchChannel connect() {
        VMPipeAsynchChannelPipe pipe = new VMPipeAsynchChannelPipe();
        this.acceptListener.onAccept(pipe.getRightAsynchChannel());
        return pipe.getLeftAsynchChannel();
    }
}

