/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.pnuts.util.LRUCache;
import org.pnuts.util.Stack;
import pnuts.compiler.CodeLoader;
import pnuts.compiler.Compiler;
import pnuts.compiler.DynamicProxy;
import pnuts.compiler.DynamicProxyFactory;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Runtime;

public class DynamicRuntime
extends Runtime {
    private static final boolean DEBUG = false;
    private static final Object[] noarg = new Object[0];
    private CodeLoader codeLoader = null;
    private Runtime _rt = null;
    static boolean hasCollection = false;
    static MethodFinder methodFinder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _callMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target) {
        try {
            CodeLoader cl = this.codeLoader;
            DynamicRuntime dynamicRuntime = this;
            synchronized (dynamicRuntime) {
                if (cl == null) {
                    this.codeLoader = cl = Compiler.createCodeLoader(context.getClassLoader(), true);
                }
            }
            return this.callMethod(context, c, name, args, types, target, cl);
        }
        catch (IllegalAccessException e0) {
            throw new PnutsException(e0, context);
        }
        catch (InvocationTargetException e1) {
            Throwable t = e1.getTargetException();
            if (t instanceof PnutsException) {
                throw (PnutsException)t;
            }
            throw new PnutsException(t, context);
        }
        catch (NoMemberFoundException e2) {
            throw new PnutsException("method.notFound", new Object[]{name, c.getName(), Pnuts.format(args)}, context);
        }
    }

    Object callMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target, CodeLoader codeLoader) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ProxyCache[] m;
        ProxyCache methodCache = null;
        if (name == Runtime.CLONE && args.length == 0) {
            if (target instanceof Object[]) {
                return ((Object[])target).clone();
            }
            if (target instanceof int[]) {
                return ((int[])target).clone();
            }
            if (target instanceof byte[]) {
                return ((byte[])target).clone();
            }
            if (target instanceof short[]) {
                return ((short[])target).clone();
            }
            if (target instanceof char[]) {
                return ((char[])target).clone();
            }
            if (target instanceof long[]) {
                return ((long[])target).clone();
            }
            if (target instanceof float[]) {
                return ((float[])target).clone();
            }
            if (target instanceof double[]) {
                return ((double[])target).clone();
            }
            if (target instanceof boolean[]) {
                return ((boolean[])target).clone();
            }
        }
        if ((m = methodFinder.getMethods(context, c, name)) == null) {
            return super._callMethod(context, c, name, args, types, target);
        }
        int count = 0;
        int min = Integer.MAX_VALUE;
        Stack methods = new Stack();
        int nargs = args.length;
        block4: for (int i = 0; i < m.length; ++i) {
            Class[] p = m[i].paramTypes;
            if (p.length != nargs) continue;
            count = 0;
            for (int j = 0; j < p.length; ++j) {
                int t;
                Class tj;
                Class pj = p[j];
                if (types != null && (tj = types[j]) != null && pj != tj && !pj.isAssignableFrom(tj) || (t = Runtime.matchType(pj, args[j])) < 0) continue block4;
                count += t;
            }
            if (count > min || m[i].type == 1 != (target == null)) continue;
            if (count < min) {
                methods.removeAllElements();
                methods.push(m[i]);
                min = count;
                continue;
            }
            if (count != min) continue;
            methods.push(m[i]);
        }
        block6: for (Class clazz = c; clazz != null; clazz = clazz.getSuperclass()) {
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                methodCache = (ProxyCache)methods.pop();
                if (methodCache.declaringClass == clazz) break block6;
            }
        }
        if (methodCache != null) {
            boolean retry = false;
            while (true) {
                if (methodCache.proxy == null || retry) {
                    methodCache.proxy = DynamicProxyFactory.makeProxy(name, methodCache.targetClass, methodCache.returnType, methodCache.paramTypes, methodCache.type, codeLoader);
                }
                try {
                    if (nargs == 0) {
                        return methodCache.invoke(target);
                    }
                    return methodCache.invoke(target, args);
                }
                catch (LinkageError err) {
                    if (!retry) {
                        codeLoader = Compiler.createCodeLoader(DynamicRuntime.getClassLoader(c), true);
                        retry = true;
                        continue;
                    }
                    methodFinder.useReflection(c);
                    return super._callMethod(context, c, name, args, types, target);
                }
                catch (PnutsException pex) {
                    throw pex;
                }
                catch (Throwable t) {
                    if (t instanceof ClassNotFoundException) {
                        methodFinder.useReflection(c);
                        return super._callMethod(context, c, name, args, types, target);
                    }
                    throw new PnutsException(t, context);
                }
                break;
            }
        }
        throw new NoMemberFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _callConstructor(Context context, Class c, Object[] args, Class[] types) {
        try {
            CodeLoader cl = this.codeLoader;
            DynamicRuntime dynamicRuntime = this;
            synchronized (dynamicRuntime) {
                if (cl == null) {
                    this.codeLoader = cl = Compiler.createCodeLoader(context.getClassLoader(), true);
                }
            }
            return this._callConstructor(context, c, args, types, cl);
        }
        catch (InvocationTargetException e1) {
            Throwable t = e1.getTargetException();
            if (t instanceof PnutsException) {
                throw (PnutsException)t;
            }
            throw new PnutsException(t, context);
        }
        catch (NoMemberFoundException e2) {
            throw new PnutsException("constructor.notFound", new Object[]{c, Pnuts.format(args)}, context);
        }
        catch (PnutsException e3) {
            throw e3;
        }
        catch (Throwable e4) {
            throw new PnutsException(e4, context);
        }
    }

    protected Object _callConstructor(Context context, Class c, Object[] args, Class[] types, CodeLoader codeLoader) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        ProxyCache[] cs = methodFinder.getConstructors(context, c);
        ProxyCache cons = null;
        if (cs == null) {
            return super._callConstructor(context, c, args, types);
        }
        int count = 0;
        int min = Integer.MAX_VALUE;
        block4: for (int i = 0; i < cs.length; ++i) {
            Class[] p = cs[i].paramTypes;
            if (p.length != args.length) continue;
            count = 0;
            for (int j = 0; j < p.length; ++j) {
                int t;
                Class tj;
                Class pj = p[j];
                if (types != null && (tj = types[j]) != null && pj != tj && !pj.isAssignableFrom(tj) || (t = Runtime.matchType(pj, args[j])) < 0) continue block4;
                count += t;
            }
            if (count >= min) continue;
            min = count;
            cons = cs[i];
        }
        if (cons != null) {
            boolean retry = false;
            while (true) {
                if (cons.proxy == null || retry) {
                    cons.proxy = DynamicProxyFactory.makeProxy("<init>", cons.declaringClass, cons.returnType, cons.paramTypes, 2, codeLoader);
                }
                try {
                    if (args.length == 0) {
                        return cons.invoke(null);
                    }
                    return cons.invoke(null, args);
                }
                catch (NoClassDefFoundError err) {
                    if (!retry) {
                        codeLoader = Compiler.createCodeLoader(DynamicRuntime.getClassLoader(c), true);
                        retry = true;
                        continue;
                    }
                    methodFinder.useReflection(c);
                    return super._callConstructor(context, c, args, types);
                }
                catch (PnutsException pex) {
                    throw pex;
                }
                catch (Throwable t) {
                    if (t instanceof ClassNotFoundException || t instanceof IllegalAccessError) {
                        methodFinder.useReflection(c);
                        return super._callConstructor(context, c, args, types);
                    }
                    throw new PnutsException(t, context);
                }
                break;
            }
        }
        throw new NoMemberFoundException();
    }

    public static PnutsFunction makeProxy(Constructor cons) {
        final DynamicProxy px = DynamicProxyFactory.makeProxy(cons, Compiler.createCodeLoader(DynamicRuntime.getClassLoader(cons.getDeclaringClass()), true));
        if (cons.getParameterTypes().length == 0) {
            return new PnutsFunction(){

                public Object exec(Object[] args, Context context) {
                    return px.invoke(null);
                }
            };
        }
        return new PnutsFunction(){

            public Object exec(Object[] args, Context context) {
                return px.invoke(null, args);
            }
        };
    }

    public static PnutsFunction makeProxy(Method method) {
        final DynamicProxy px = DynamicProxyFactory.makeProxy(method, Compiler.createCodeLoader(DynamicRuntime.getClassLoader(method.getDeclaringClass()), true));
        final String _name = method.getName();
        boolean _static = Modifier.isStatic(method.getModifiers());
        int nargs = method.getParameterTypes().length;
        if (_static) {
            if (nargs == 0) {
                return new PnutsFunction(){

                    public String getName() {
                        return _name;
                    }

                    public Object exec(Object[] args, Context context) {
                        return px.invoke(null);
                    }
                };
            }
            return new PnutsFunction(){

                public String getName() {
                    return _name;
                }

                public Object exec(Object[] args, Context context) {
                    return px.invoke(null, args);
                }
            };
        }
        if (nargs == 0) {
            return new PnutsFunction(){

                public String getName() {
                    return _name;
                }

                public Object exec(Object[] args, Context context) {
                    return px.invoke(args[0]);
                }
            };
        }
        return new PnutsFunction(){

            public String getName() {
                return _name;
            }

            public Object exec(Object[] args, Context context) {
                Object target = args[0];
                System.arraycopy(args, 1, args, 0, args.length - 1);
                return px.invoke(target, args);
            }
        };
    }

    static ClassLoader getClassLoader(final Class clazz) {
        if (Compiler.hasJava2Security) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    protected Runtime.Accessor createBeanAccessor(Class cls, Class stopClass) {
        return new DynamicAccessor(cls, stopClass);
    }

    static DynamicProxy createReflectionProxy(Class cls, String name, Class stopClass) {
        try {
            BeanInfo beanInfo = stopClass == null ? Introspector.getBeanInfo(cls) : Introspector.getBeanInfo(cls, stopClass);
            PropertyDescriptor[] pd = beanInfo.getPropertyDescriptors();
            AccessibleObject w = null;
            AccessibleObject r = null;
            for (int i = 0; i < pd.length; ++i) {
                PropertyDescriptor p = pd[i];
                String pname = p.getName();
                if (!pname.equals(name)) continue;
                r = p.getReadMethod();
                w = p.getWriteMethod();
            }
            if (r != null) {
                r.setAccessible(true);
            }
            if (w != null) {
                w.setAccessible(true);
            }
            AccessibleObject readMethod = r;
            AccessibleObject writeMethod = w;
            DynamicProxy px = new DynamicProxy((Method)readMethod, (Method)writeMethod){
                private final /* synthetic */ Method val$readMethod;
                private final /* synthetic */ Method val$writeMethod;
                {
                    this.val$readMethod = method;
                    this.val$writeMethod = method2;
                }

                public Object invoke(Object target) {
                    try {
                        return this.val$readMethod.invoke(target, noarg);
                    }
                    catch (IllegalAccessException iae) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    return null;
                }

                public Object invoke(Object target, Object[] args) {
                    try {
                        this.val$writeMethod.invoke(target, args);
                    }
                    catch (IllegalAccessException iae) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    return null;
                }
            };
            return px;
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    public Object getBeanProperty(Object target, String name) {
        return this.getBeanProperty(target, name, null);
    }

    protected Object getBeanProperty(Object target, String name, Class stopClass) {
        Runtime.Accessor a = this.getAccessor(target.getClass(), stopClass);
        ProxyCache readMethodProxy = (ProxyCache)a.findReadMethod(name);
        if (readMethodProxy != null) {
            return readMethodProxy.invoke(target);
        }
        throw new IllegalArgumentException("not readable property: target=" + target + ", fieldName=" + name);
    }

    public void setBeanProperty(Object target, String name, Object value) {
        this.setBeanProperty(target, name, value, null);
    }

    protected void setBeanProperty(Object target, String name, Object value, Class stopClass) {
        Runtime.Accessor a = this.getAccessor(target.getClass(), stopClass);
        ProxyCache writeMethodProxy = (ProxyCache)a.findWriteMethod(name);
        if (writeMethodProxy != null) {
            try {
                Object[] arg = new Object[]{value};
                writeMethodProxy.invoke(target, arg);
                return;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("argument type mismatch, target=" + target + ", fieldName=" + name + ", value=" + value);
            }
        }
        throw new IllegalArgumentException("not writable property: target=" + target + ", fieldName=" + name);
    }

    public Class getBeanPropertyType(Class cls, String name) {
        return this.getAccessor(cls, null).getType(name);
    }

    static /* synthetic */ Method[] access$000(Context x0, Class x1) {
        return Runtime.getMethods(x0, x1);
    }

    static /* synthetic */ Constructor[] access$100(Context x0, Class x1) {
        return Runtime.getConstructors(x0, x1);
    }

    static /* synthetic */ Method[] access$200(Context x0, Class x1) {
        return Runtime.getMethods(x0, x1);
    }

    static /* synthetic */ Method access$300(Class x0, String x1, Class[] x2) {
        return Runtime.findCallableMethod(x0, x1, x2);
    }

    static /* synthetic */ Constructor[] access$400(Context x0, Class x1) {
        return Runtime.getConstructors(x0, x1);
    }

    static /* synthetic */ Method access$500(Class x0, String x1, Class[] x2) {
        return Runtime.findCallableMethod(x0, x1, x2);
    }

    static /* synthetic */ Method access$600(Class x0, String x1, Class[] x2) {
        return Runtime.findCallableMethod(x0, x1, x2);
    }

    static {
        try {
            Class.forName("java.util.Collection");
            hasCollection = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean ref = false;
        try {
            Class.forName("java.lang.ref.SoftReference");
            ref = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        methodFinder = ref && hasCollection ? new Java2MethodFinder() : new ClassicMethodFinder();
    }

    protected static class DynamicAccessor
    extends Runtime.Accessor {
        boolean isPublic;

        protected DynamicAccessor(Class cls, Class stopClass) {
            super(cls, stopClass);
            this.isPublic = Modifier.isPublic(cls.getModifiers());
        }

        public void addReadMethod(String name, Object method) {
            Method m;
            Method m0 = m = (Method)method;
            if (!this.isPublic) {
                String methodName = m.getName();
                Class[] types = m.getParameterTypes();
                m = DynamicRuntime.access$500(this.beanClass, methodName, types);
            }
            if (m != null) {
                CodeLoader loader = Compiler.createCodeLoader(DynamicRuntime.getClassLoader(m.getDeclaringClass()), true);
                DynamicProxy px = DynamicProxyFactory.makeProxy(m, loader);
                ProxyCache pc = new ProxyCache(m, this.beanClass);
                pc.proxy = px;
                super.addReadMethod(name, pc);
            } else {
                DynamicProxy px = DynamicRuntime.createReflectionProxy(this.beanClass, name, this.stopClass);
                ProxyCache pc = new ProxyCache(m0, this.beanClass);
                pc.proxy = px;
                super.addReadMethod(name, pc);
                super.addWriteMethod(name, pc);
            }
        }

        public void addWriteMethod(String name, Object method) {
            Method m;
            Method m0 = m = (Method)method;
            if (!this.isPublic) {
                String methodName = m.getName();
                Class[] types = m.getParameterTypes();
                m = DynamicRuntime.access$600(this.beanClass, methodName, types);
            }
            if (m != null) {
                CodeLoader loader = Compiler.createCodeLoader(DynamicRuntime.getClassLoader(m.getDeclaringClass()), true);
                DynamicProxy px = DynamicProxyFactory.makeProxy(m, loader);
                ProxyCache pc = new ProxyCache(m, this.beanClass);
                pc.proxy = px;
                super.addWriteMethod(name, pc);
            } else {
                DynamicProxy px = DynamicRuntime.createReflectionProxy(this.beanClass, name, this.stopClass);
                ProxyCache pc = new ProxyCache(m0, this.beanClass);
                pc.proxy = px;
                super.addReadMethod(name, pc);
                super.addWriteMethod(name, pc);
            }
        }
    }

    static class NoMemberFoundException
    extends RuntimeException {
        NoMemberFoundException() {
        }
    }

    static class Java2MethodFinder
    extends MethodFinder {
        private static HashMap mtab = new HashMap();
        private static HashMap ctab = new HashMap();
        private static SoftReference USE_REFLECTION = new SoftReference(new HashMap(0));

        Java2MethodFinder() {
        }

        public void useReflection(Class c) {
            mtab.put(c, USE_REFLECTION);
            ctab.put(c, USE_REFLECTION);
        }

        public ProxyCache[] getMethods(Context context, Class c, String name) {
            HashMap map;
            SoftReference cache = (SoftReference)mtab.get(c);
            if (cache == null || (map = (HashMap)cache.get()) == null) {
                map = new HashMap();
                mtab.put(c, new SoftReference<HashMap>(map));
            } else if (cache == USE_REFLECTION) {
                return null;
            }
            Object v = map.get(name);
            if (v instanceof ProxyCache[]) {
                return (ProxyCache[])v;
            }
            boolean isPublic = Modifier.isPublic(c.getModifiers());
            Method[] m = DynamicRuntime.access$200(context, c);
            if (m == null) {
                throw new NoClassDefFoundError("" + c);
            }
            int j = 0;
            for (int i = 0; i < m.length; ++i) {
                String m_name = m[i].getName().intern();
                if (!m_name.equals(name) || i < j) continue;
                m[j] = m[i];
                ++j;
            }
            ProxyCache[] px = new ProxyCache[j];
            for (int i = 0; i < j; ++i) {
                Method mi = DynamicRuntime.access$300(c, m[i].getName(), m[i].getParameterTypes());
                px[i] = mi != null ? new ProxyCache(mi, c) : new ProxyCache(m[i], c);
            }
            map.put(name, px);
            return px;
        }

        public ProxyCache[] getConstructors(Context context, Class c) {
            ProxyCache[] pc;
            SoftReference cache = (SoftReference)ctab.get(c);
            if (cache == USE_REFLECTION) {
                return null;
            }
            if (cache == null || (pc = (ProxyCache[])cache.get()) == null) {
                Constructor[] con = DynamicRuntime.access$400(context, c);
                ProxyCache[] px = new ProxyCache[con.length];
                for (int i = 0; i < con.length; ++i) {
                    px[i] = new ProxyCache(con[i]);
                }
                ctab.put(c, new SoftReference<ProxyCache[]>(px));
                return px;
            }
            return pc;
        }
    }

    static class ClassicMethodFinder
    extends MethodFinder {
        private static LRUCache mtab = new LRUCache(512);
        private static LRUCache ctab = new LRUCache(512);
        private static LRUCache USE_REFLECTION = new LRUCache(0);

        ClassicMethodFinder() {
        }

        public void useReflection(Class c) {
            mtab.put(c, USE_REFLECTION);
            ctab.put(c, USE_REFLECTION);
        }

        public synchronized ProxyCache[] getMethods(Context context, Class c, String name) {
            LRUCache cache = (LRUCache)mtab.get(c);
            if (cache == null) {
                cache = new LRUCache(512);
                mtab.put(c, cache);
            } else if (cache == USE_REFLECTION) {
                return null;
            }
            Object v = cache.get(name);
            if (v instanceof ProxyCache[]) {
                return (ProxyCache[])v;
            }
            Method[] m = DynamicRuntime.access$000(context, c);
            if (m == null) {
                throw new NoClassDefFoundError("" + c);
            }
            int j = 0;
            for (int i = 0; i < m.length; ++i) {
                String m_name = m[i].getName().intern();
                if (m_name != name || i < j) continue;
                m[j] = m[i];
                ++j;
            }
            ProxyCache[] px = new ProxyCache[j];
            for (int i = 0; i < j; ++i) {
                px[i] = new ProxyCache(m[i], c);
            }
            cache.put(name, px);
            return px;
        }

        public synchronized ProxyCache[] getConstructors(Context context, Class c) {
            Object v = ctab.get(c);
            if (v instanceof ProxyCache[]) {
                return (ProxyCache[])v;
            }
            if (v == USE_REFLECTION) {
                return null;
            }
            Constructor[] con = DynamicRuntime.access$100(context, c);
            ProxyCache[] px = new ProxyCache[con.length];
            for (int i = 0; i < con.length; ++i) {
                px[i] = new ProxyCache(con[i]);
            }
            ctab.put(c, px);
            return px;
        }
    }

    static abstract class MethodFinder {
        MethodFinder() {
        }

        public abstract ProxyCache[] getConstructors(Context var1, Class var2);

        public abstract ProxyCache[] getMethods(Context var1, Class var2, String var3);

        public abstract void useReflection(Class var1);
    }

    static class ProxyCache {
        static final int DEFAULT = 0;
        static final int STATIC = 1;
        static final int CONSTRUCTOR = 2;
        Class[] paramTypes;
        Class declaringClass;
        Class targetClass;
        Class returnType;
        int type;
        DynamicProxy proxy;
        boolean hasArrayParam;

        ProxyCache(Method method, Class clazz) {
            this.paramTypes = method.getParameterTypes();
            this.declaringClass = method.getDeclaringClass();
            this.returnType = method.getReturnType();
            this.type = Modifier.isStatic(method.getModifiers()) ? 1 : 0;
            this.targetClass = clazz;
            this.init();
        }

        ProxyCache(Constructor cons) {
            this.paramTypes = cons.getParameterTypes();
            this.declaringClass = cons.getDeclaringClass();
            this.targetClass = cons.getDeclaringClass();
            this.returnType = Void.TYPE;
            this.type = 2;
            this.init();
        }

        void init() {
            Class[] types = this.paramTypes;
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].isArray()) continue;
                this.hasArrayParam = true;
                break;
            }
        }

        Object invoke(Object target) {
            return this.proxy.invoke(target);
        }

        Object invoke(Object target, Object[] args) {
            if (this.hasArrayParam) {
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    Class type = this.paramTypes[i];
                    Object arg = args[i];
                    if (!type.isArray() || type.isInstance(arg)) continue;
                    args[i] = Runtime.transform(Runtime.getBottomType(type), arg);
                }
            }
            return this.proxy.invoke(target, args);
        }
    }
}

