/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import pnuts.lang.BinaryOperator;
import pnuts.lang.BooleanOperator;
import pnuts.lang.Context;
import pnuts.lang.JDK11Configuration;
import pnuts.lang.Java2Configuration;
import pnuts.lang.MerlinConfiguration;
import pnuts.lang.Runtime;
import pnuts.lang.UnaryOperator;

public abstract class Configuration
implements Serializable {
    protected static Configuration normalConfiguration;
    private static Configuration defaultConfiguration;
    protected BinaryOperator _add;
    protected BinaryOperator _subtract;
    protected BinaryOperator _multiply;
    protected BinaryOperator _mod;
    protected BinaryOperator _divide;
    protected BinaryOperator _shiftArithmetic;
    protected BinaryOperator _shiftLeft;
    protected BinaryOperator _shiftRight;
    protected BinaryOperator _and;
    protected BinaryOperator _or;
    protected BinaryOperator _xor;
    protected UnaryOperator _add1;
    protected UnaryOperator _subtract1;
    protected UnaryOperator _not;
    protected UnaryOperator _negate;
    protected BooleanOperator _eq;
    protected BooleanOperator _lt;
    protected BooleanOperator _le;
    protected BooleanOperator _gt;
    protected BooleanOperator _ge;

    public static Configuration getDefault() {
        return defaultConfiguration;
    }

    public Configuration() {
        this.initializeOperators();
    }

    protected void initializeOperators() {
        this._add = BinaryOperator.Add.instance;
        this._subtract = BinaryOperator.Subtract.instance;
        this._multiply = BinaryOperator.Multiply.instance;
        this._mod = BinaryOperator.Mod.instance;
        this._divide = BinaryOperator.Divide.instance;
        this._shiftArithmetic = BinaryOperator.ShiftArithmetic.instance;
        this._shiftLeft = BinaryOperator.ShiftLeft.instance;
        this._shiftRight = BinaryOperator.ShiftRight.instance;
        this._and = BinaryOperator.And.instance;
        this._or = BinaryOperator.Or.instance;
        this._xor = BinaryOperator.Xor.instance;
        this._add1 = UnaryOperator.Add1.instance;
        this._subtract1 = UnaryOperator.Subtract1.instance;
        this._not = UnaryOperator.Not.instance;
        this._negate = UnaryOperator.Negate.instance;
        this._eq = BooleanOperator.EQ.instance;
        this._lt = BooleanOperator.LT.instance;
        this._le = BooleanOperator.LE.instance;
        this._gt = BooleanOperator.GT.instance;
        this._ge = BooleanOperator.GE.instance;
    }

    public abstract Object getStaticField(Context var1, Class var2, String var3);

    public abstract void putStaticField(Context var1, Class var2, String var3, Object var4);

    public abstract Object getElement(Context var1, Object var2, Object var3);

    public abstract void setElement(Context var1, Object var2, Object var3, Object var4);

    public abstract Object callMethod(Context var1, Class var2, String var3, Object[] var4, Class[] var5, Object var6);

    public abstract Object callConstructor(Context var1, Class var2, Object[] var3, Class[] var4);

    public abstract Method[] getMethods(Class var1);

    public abstract Constructor[] getConstructors(Class var1);

    public abstract Object getRange(Context var1, Object var2, Object var3, Object var4);

    public abstract Object setRange(Context var1, Object var2, Object var3, Object var4, Object var5);

    public abstract Object getField(Context var1, Object var2, String var3);

    public abstract void putField(Context var1, Object var2, String var3, Object var4);

    public abstract Enumeration toEnumeration(Object var1);

    protected static Object invokeMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target) {
        return context.runtime._callMethod(context, c, name, args, types, target);
    }

    Object reInvoke(IllegalAccessException t, Method method, Object target, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return normalConfiguration.reInvoke(t, method, target, args);
    }

    protected ClassLoader getInitialClassLoader() {
        return null;
    }

    void replace(StringBuffer buf, int start, int end, String str) {
        normalConfiguration.replace(buf, start, end, str);
    }

    static {
        boolean hasCharSequence = false;
        try {
            Class.forName("java.lang.CharSequence");
            hasCharSequence = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean java2 = false;
        try {
            Class.forName("java.util.Collection");
            Class.forName("java.security.AccessController");
            java2 = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        normalConfiguration = hasCharSequence ? new MerlinConfiguration() : (java2 ? new Java2Configuration() : new JDK11Configuration());
        try {
            String property = Runtime.getProperty("pnuts.lang.defaultConfiguration");
            if (property != null && !property.equals("pnuts.lang.Configuration")) {
                Class<?> cls = Class.forName(property);
                defaultConfiguration = (Configuration)cls.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultConfiguration == null) {
            defaultConfiguration = normalConfiguration;
        }
    }
}

