/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import pnuts.lang.AbstractData;
import pnuts.lang.Context;
import pnuts.lang.Indexed;
import pnuts.lang.JavaBeansConfiguration;
import pnuts.lang.PnutsException;
import pnuts.lang.Property;
import pnuts.lang.Runtime;

class JDK11Configuration
extends JavaBeansConfiguration {
    JDK11Configuration() {
    }

    JDK11Configuration(Class stopClass) {
        super(stopClass);
    }

    public Object getField(Context context, Object target, String name) {
        if (target instanceof Context) {
            return ((Context)target).get(name);
        }
        if (target instanceof Property) {
            return ((Property)target).get(name, context);
        }
        return super.getField(context, target, name);
    }

    public void putField(Context context, Object target, String name, Object value) {
        if (target instanceof Context) {
            ((Context)target).set(name, value);
        } else if (target instanceof Property) {
            ((Property)target).set(name, value, context);
        } else {
            super.putField(context, target, name, value);
        }
    }

    public Object getStaticField(Context context, Class clazz, String name) {
        try {
            return clazz.getField(name).get(null);
        }
        catch (PnutsException p) {
            throw p;
        }
        catch (NoSuchFieldException f) {
            throw new PnutsException("field.notFound", new Object[]{name, clazz}, context);
        }
        catch (Throwable t) {
            throw new PnutsException(t, context);
        }
    }

    public void putStaticField(Context context, Class clazz, String name, Object value) {
        try {
            Field field = clazz.getField(name);
            Class<?> type = field.getType();
            if (type.isArray() && value != null && Runtime.isArray(value) && !type.isInstance(value)) {
                value = Runtime.transform(Runtime.getBottomType(type), value);
            }
            field.set(null, value);
        }
        catch (PnutsException e0) {
            throw e0;
        }
        catch (NoSuchFieldException f) {
            throw new PnutsException("field.notFound", new Object[]{name, clazz}, context);
        }
        catch (Throwable e) {
            throw new PnutsException(e, context);
        }
    }

    public Method[] getMethods(Class cls) {
        return cls.getMethods();
    }

    public Object callMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target) {
        try {
            if (target instanceof AbstractData) {
                return ((AbstractData)target).invoke(name, args, context);
            }
            return super.callMethod(context, c, name, args, types, target);
        }
        catch (PnutsException e1) {
            throw e1;
        }
        catch (Throwable e2) {
            throw new PnutsException(e2, context);
        }
    }

    public Constructor[] getConstructors(Class c) {
        return c.getConstructors();
    }

    public Object getElement(Context context, Object target, Object key) {
        int index = ((Number)key).intValue();
        if (target instanceof Object[]) {
            return ((Object[])target)[index];
        }
        if (target instanceof Indexed) {
            return ((Indexed)target).get(index);
        }
        if (target instanceof Property) {
            return ((Property)target).get((String)key, context);
        }
        if (target instanceof String) {
            return new Character(((String)target).charAt(index));
        }
        return Array.get(target, index);
    }

    public void setElement(Context context, Object target, Object key, Object value) {
        int index = ((Number)key).intValue();
        if (target instanceof Object[]) {
            ((Object[])target)[index] = value;
        } else if (target instanceof Indexed) {
            ((Indexed)target).set(index, value);
        } else if (target instanceof Property) {
            ((Property)target).set((String)key, value, context);
        } else {
            Array.set(target, index, value);
        }
    }

    public Object getRange(Context context, Object target, Object idx1, Object idx2) {
        int from = ((Number)idx1).intValue();
        int to = 0;
        if (idx2 != null) {
            to = ((Number)idx2).intValue();
        }
        if (target instanceof String) {
            String s = (String)target;
            int len = s.length();
            if (from > len - 1) {
                return "";
            }
            if (idx2 != null) {
                if (from > to || to < 0) {
                    return "";
                }
                if (from < 0) {
                    from = 0;
                }
                if (to > len - 1) {
                    to = len - 1;
                }
                return s.substring(from, to + 1);
            }
            if (from < 0) {
                from = 0;
            }
            return s.substring(from);
        }
        if (Runtime.isArray(target)) {
            int size;
            Class<?> c = target.getClass().getComponentType();
            int len = Runtime.getArrayLength(target);
            if (from > len - 1) {
                return Array.newInstance(c, 0);
            }
            if (idx2 == null) {
                to = len - 1;
            } else {
                if (from > to || to < 0) {
                    return Array.newInstance(c, 0);
                }
                if (to > len - 1) {
                    to = len - 1;
                }
            }
            if (from < 0) {
                from = 0;
            }
            if ((size = to - from + 1) < 0) {
                size = 0;
            } else if (from + size > len) {
                size = len - from;
            }
            Object ret = Array.newInstance(c, size);
            if (size > 0) {
                System.arraycopy(target, from, ret, 0, size);
            }
            return ret;
        }
        throw new PnutsException("illegal.type", PnutsException.NO_PARAM, context);
    }

    public Object setRange(Context context, Object target, Object idx1, Object idx2, Object expr) {
        int from = ((Number)idx1).intValue();
        int to = 0;
        if (idx2 != null && (from > (to = ((Number)idx2).intValue()) || to < 0)) {
            return target;
        }
        if (target instanceof String) {
            StringBuffer s = new StringBuffer((String)target);
            int len = s.length();
            if (from > len - 1) {
                return target;
            }
            if (idx2 == null) {
                to = len - 1;
            } else if (to > len - 1) {
                to = len - 1;
            }
            if (from < 0) {
                from = 0;
            }
            if (expr instanceof Character) {
                char c = ((Character)expr).charValue();
                for (int i = from; i < to + 1; ++i) {
                    s.setCharAt(i, c);
                }
            } else {
                this.replace(s, from, to + 1, String.valueOf(expr));
            }
            String val = s.toString();
            return val;
        }
        if (Runtime.isArray(target)) {
            int size;
            int len = Runtime.getArrayLength(target);
            if (from > len - 1) {
                return target;
            }
            if (idx2 == null) {
                to = len - 1;
            } else if (to > len - 1) {
                to = len - 1;
            }
            if (from < 0) {
                from = 0;
            }
            if (from + (size = to - from + 1) > len) {
                size = len - from;
            }
            if (target instanceof char[] && expr instanceof String) {
                String str = (String)expr;
                int end = str.length();
                if (end > to - from + 1) {
                    end = to - from + 1;
                }
                str.getChars(0, end, (char[])target, from);
            } else {
                for (int i = from; i < to + 1; ++i) {
                    Array.set(target, i, expr);
                }
            }
            return target;
        }
        throw new PnutsException("illegal.type", PnutsException.NO_PARAM, context);
    }

    public Enumeration toEnumeration(Object obj) {
        if (obj instanceof Enumeration) {
            return (Enumeration)obj;
        }
        if (Runtime.isArray(obj)) {
            return new ArrayEnum(obj);
        }
        if (obj instanceof String) {
            return new StringEnum((String)obj);
        }
        return null;
    }

    Object reInvoke(IllegalAccessException t, Method method, Object target, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m;
        if (target != null && (m = JDK11Configuration.findCallableMethod(target.getClass(), method.getName(), method.getParameterTypes())) != null) {
            return m.invoke(target, args);
        }
        throw t;
    }

    private static Method findCallableMethod(Class clazz, String name, Class[] args) {
        Method method = null;
        if (!clazz.isInterface()) {
            Class<?>[] it = clazz.getInterfaces();
            for (int i = 0; i < it.length; ++i) {
                if (!Modifier.isPublic(it[i].getModifiers())) continue;
                try {
                    method = it[i].getMethod(name, args);
                    if (method == null) continue;
                    return method;
                }
                catch (NoSuchMethodException nsme) {
                    // empty catch block
                }
            }
            try {
                method = clazz.getSuperclass().getMethod(name, args);
                if (method != null && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
        }
        return null;
    }

    void replace(StringBuffer buf, int start, int end, String str) {
        int count = buf.length();
        int chars = count - end;
        if (start >= 0 && start < count) {
            if (chars > 0) {
                char[] tmp = new char[chars];
                buf.getChars(end, count, tmp, 0);
                buf.setLength(start);
                buf.append(str);
                buf.append(tmp);
            } else {
                buf.setLength(start);
                buf.append(str);
            }
        }
    }

    static class StringEnum
    implements Enumeration {
        String str;
        int len;
        int pos = 0;

        StringEnum(String str) {
            this.str = str;
            this.len = str.length();
        }

        public boolean hasMoreElements() {
            return this.len > this.pos;
        }

        public Object nextElement() {
            return new Character(this.str.charAt(this.pos++));
        }
    }

    static class ArrayEnum
    implements Enumeration {
        Object array;
        int idx;
        int len;

        ArrayEnum(Object array) {
            this.array = array;
            this.idx = 0;
            this.len = Array.getLength(array);
        }

        public boolean hasMoreElements() {
            return this.idx < this.len;
        }

        public Object nextElement() {
            return Array.get(this.array, this.idx++);
        }
    }
}

