/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.io.FileWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

class LogReader
extends FilterReader {
    FileWriter writer;

    LogReader(Reader in, String path) throws IOException {
        super(in);
        this.writer = new FileWriter(path);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    LogReader.this.writer.flush();
                    LogReader.this.writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public int read() throws IOException {
        int c = super.read();
        this.writer.write(c);
        this.writer.flush();
        return c;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int n = super.read(cbuf, off, len);
        if (n > 0) {
            this.writer.write(cbuf, off, n);
            this.writer.flush();
        }
        return n;
    }

    public void close() throws IOException {
        super.close();
        this.writer.close();
    }
}

