/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessHistoryBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.ProcessFilterConverter;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import org.apache.log4j.Logger;

public class MySQLProcessDAO
extends AbstractDAO
implements ProcessDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String PROC_ID = "PROC_ID";
    public static final String NAME = "NAME";
    public static final String PACKAGE_ID = "PACKAGE_ID";
    public static final String PROC_DEF_ID = "PROC_DEF_ID";
    public static final String START_DATE = "START_DATE";
    public static final String STARTER_ID = "STARTER_ID";
    public static final String DURATION_LIMIT = "DURATION_LIMIT";
    public static final String PROC_STATE = "PROC_STATE";
    public static final String UPDATE_DATE = "UPDATE_DATE";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from PROCESS where PROC_ID = ? ";
    private static final String SQL_SELECT_BY_PID_AND_PDID = "select * from PROCESS where PROC_DEF_ID = ? and PROC_ID = ? ";
    private static final String SQL_SELECT_BY_PDID = "select * from PROCESS where PROC_DEF_ID = ? ";
    private static final String SQL_SELECT = "select * from PROCESS ";
    private static final String SQL_SELECT_COUNT_BY_PDID = "select COUNT(*) from PROCESS where PROC_DEF_ID = ? ";
    private static final String SQL_INSERT = "insert into PROCESS (PROC_ID, NAME, PACKAGE_ID, PROC_DEF_ID, START_DATE, STARTER_ID, DURATION_LIMIT, PROC_STATE, UPDATE_DATE) values (?,?,?,?,?,?,?,?,?)";
    private static final String SQL_UPDATE_NAME = "UPDATE PROCESS SET NAME = ? WHERE PROC_ID = ? ";
    private static final String SQL_UPDATE_STATE = "UPDATE PROCESS SET PROC_STATE = ?, UPDATE_DATE = ? WHERE PROC_ID = ? ";
    private static final String SQL_UPDATE_DATE = "UPDATE PROCESS SET UPDATE_DATE = ? WHERE PROC_ID = ? ";

    MySQLProcessDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessBean findByPrimaryKey(String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ProcessBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            ProcessBean processBean = bean;
            return processBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessBean findByPDIDandPID(String pdid, String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PID_AND_PDID);
        try {
            st.setString(1, pdid);
            st.setString(2, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ProcessBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            ProcessBean processBean = bean;
            return processBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessBean[] findByPDID(String pdid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PDID);
        try {
            st.setString(1, pdid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<ProcessBean> list = new ArrayList<ProcessBean>();
            while (rs.next()) {
                ProcessBean bean = this.createBean(rs);
                list.add(bean);
            }
            ProcessBean[] processBeanArray = list.toArray(new ProcessBean[list.size()]);
            return processBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findCountByPDID(String pdid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_COUNT_BY_PDID);
        try {
            st.setString(1, pdid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            Object bean = null;
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            return n;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessBean[] findByFilter(Filter filter) throws SQLException, DAOException, InvalidFilterException {
        ProcessFilterConverter converter = new ProcessFilterConverter();
        String where = converter.convertToSQL(filter);
        if (!where.equals("")) {
            where = " where " + where;
        }
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT + where);
        eLog.debug((Object)st.toString());
        try {
            ResultSet rs = st.executeQuery();
            ArrayList<ProcessBean> list = new ArrayList<ProcessBean>();
            while (rs.next()) {
                ProcessBean bean = this.createBean(rs);
                list.add(bean);
            }
            ProcessBean[] processBeanArray = list.toArray(new ProcessBean[list.size()]);
            return processBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessBean[] findByFilter(String pdid, Filter filter) throws SQLException, DAOException, InvalidFilterException {
        ProcessFilterConverter converter = new ProcessFilterConverter();
        String where = converter.convertToSQL(filter);
        where = where.equals("") ? " where PROC_DEF_ID = '" + pdid + "' " : " where PROC_DEF_ID = '" + pdid + "' and " + where;
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT + where);
        eLog.debug((Object)st.toString());
        try {
            ResultSet rs = st.executeQuery();
            ArrayList<ProcessBean> list = new ArrayList<ProcessBean>();
            while (rs.next()) {
                ProcessBean bean = this.createBean(rs);
                list.add(bean);
            }
            ProcessBean[] processBeanArray = list.toArray(new ProcessBean[list.size()]);
            return processBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ProcessBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getID());
            st.setString(2, bean.getName());
            st.setString(3, bean.getPackageID());
            st.setString(4, bean.getProcDefinitionID());
            st.setTimestamp(5, bean.getStartDate());
            st.setString(6, bean.getStarterID());
            st.setTimestamp(7, bean.getDurationLimit());
            st.setInt(8, bean.getProcessState());
            st.setTimestamp(9, bean.getUpdateDate());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0018");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
        try {
            WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
            ProcessHistoryDAO phDAO = factory.getProcessHistoryDAO();
            ProcessHistoryBean history = new ProcessHistoryBean();
            history.setProcID(bean.getID());
            history.setPackageID(bean.getPackageID());
            history.setProcDefID(bean.getProcDefinitionID());
            history.setPrevState(-1);
            history.setNewState(bean.getProcessState());
            history.setUpdateDate(bean.getUpdateDate());
            history.setReason("NEW PROCESS CREATION");
            phDAO.insert(history);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (DAOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E0019");
            throw new DAOException(errMsg, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateName(ProcessBean bean, String name) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_NAME);
        try {
            st.setString(1, name);
            st.setString(2, bean.getID());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0020");
                throw new DAOException(errMsg);
            }
            bean.setName(name);
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(ProcessBean bean, ProcessState state, Timestamp ts) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_STATE);
        try {
            st.setInt(1, state.toInt());
            st.setTimestamp(2, ts);
            st.setString(3, bean.getID());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0021");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
        try {
            WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
            ProcessHistoryDAO phDAO = factory.getProcessHistoryDAO();
            ProcessHistoryBean history = new ProcessHistoryBean();
            history.setProcID(bean.getID());
            history.setPackageID(bean.getPackageID());
            history.setProcDefID(bean.getProcDefinitionID());
            history.setPrevState(bean.getProcessState());
            history.setNewState(state.toInt());
            history.setUpdateDate(bean.getUpdateDate());
            ProcessState old = ProcessState.getState(bean.getProcessState());
            String msg = "PROCESS STATE CHANGED FROM " + old.toString() + " TO " + state.toString();
            history.setReason(msg);
            phDAO.insert(history);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (DAOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E0019");
            throw new DAOException(errMsg, ex);
        }
        bean.setUpdateDate(ts);
        bean.setProcessState(state.toInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(ProcessBean bean, Timestamp ts) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_DATE);
        try {
            st.setTimestamp(1, ts);
            st.setString(2, bean.getID());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0021");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
        try {
            ProcessState old = ProcessState.getState(bean.getProcessState());
            WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
            ProcessHistoryDAO phDAO = factory.getProcessHistoryDAO();
            ProcessHistoryBean history = new ProcessHistoryBean();
            history.setProcID(bean.getID());
            history.setPackageID(bean.getPackageID());
            history.setProcDefID(bean.getProcDefinitionID());
            history.setPrevState(bean.getProcessState());
            history.setNewState(old.toInt());
            history.setUpdateDate(bean.getUpdateDate());
            String msg = "PROCESS STATE NOTIFIED FROM " + old.toString();
            history.setReason(msg);
            phDAO.insert(history);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (DAOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E0019");
            throw new DAOException(errMsg, ex);
        }
        bean.setUpdateDate(ts);
    }

    private ProcessBean createBean(ResultSet rs) throws SQLException {
        ProcessBean bean = new ProcessBean();
        bean.setID(rs.getString(PROC_ID));
        bean.setName(rs.getString(NAME));
        bean.setPackageID(rs.getString(PACKAGE_ID));
        bean.setProcDefinitionID(rs.getString(PROC_DEF_ID));
        bean.setStartDate(rs.getTimestamp(START_DATE));
        bean.setStarterID(rs.getString(STARTER_ID));
        bean.setDurationLimit(rs.getTimestamp(DURATION_LIMIT));
        bean.setProcessState(rs.getInt(PROC_STATE));
        bean.setUpdateDate(rs.getTimestamp(UPDATE_DATE));
        return bean;
    }
}

