/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLProcessWaitActivityDAO
extends AbstractDAO
implements ProcessWaitActivityDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String PROC_ID = "PROC_ID";
    public static final String ACT_ID = "ACT_ID";
    public static final String SUBPROC_ID = "SUBPROC_ID";
    private static final String SQL_SELECT_BY_SUBPROC_ID = "select * from WAITPROCACT where SUBPROC_ID = ? ";
    private static final String SQL_SELECT_BY_PROCID_AND_ACTID = "select * from WAITPROCACT where PROC_ID = ? AND ACT_ID = ? ";
    private static final String SQL_INSERT = "insert into WAITPROCACT (PROC_ID, ACT_ID, SUBPROC_ID) values (?,?,?)";
    private static final String SQL_DELETE = "delete from WAITPROCACT where SUBPROC_ID = ? ";

    MySQLProcessWaitActivityDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessWaitActivityBean findBySubprocessID(String spid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_SUBPROC_ID);
        try {
            st.setString(1, spid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ProcessWaitActivityBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            ProcessWaitActivityBean processWaitActivityBean = bean;
            return processWaitActivityBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessWaitActivityBean findByProcIDANDActID(String pid, String aid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PROCID_AND_ACTID);
        try {
            st.setString(1, pid);
            st.setString(2, aid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ProcessWaitActivityBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            ProcessWaitActivityBean processWaitActivityBean = bean;
            return processWaitActivityBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ProcessWaitActivityBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getProcID());
            st.setString(2, bean.getActID());
            st.setString(3, bean.getSubprocID());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0024");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String spid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_DELETE);
        try {
            st.setString(1, spid);
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0023");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private ProcessWaitActivityBean createBean(ResultSet rs) throws SQLException {
        ProcessWaitActivityBean bean = new ProcessWaitActivityBean();
        bean.setProcID(rs.getString(PROC_ID));
        bean.setActID(rs.getString(ACT_ID));
        bean.setSubprocID(rs.getString(SUBPROC_ID));
        return bean;
    }
}

