/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Hashtable;
import java.util.Map;
import jp.co.argo21.nautica.workflow.engine.GeneralRequester;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ResourceInternal;
import jp.co.argo21.nautica.workflow.engine.ResourceManagerFactory;
import jp.co.argo21.nautica.workflow.engine.SessionManagerFactory;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.ParticipantHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import org.apache.log4j.Logger;

public class RequesterManager {
    private static Logger eLog = LogManager.getEngineLogger();
    private static RequesterManager singleton;
    private Map requesters = new Hashtable();

    static void create() throws Exception {
        try {
            singleton = new RequesterManager();
            singleton.init();
        }
        catch (Exception ex) {
            String E0111 = StringManager.get("E0111");
            eLog.error((Object)E0111);
            throw ex;
        }
    }

    static RequesterManager getInstance() {
        return singleton;
    }

    private RequesterManager() {
    }

    private void init() throws Exception {
    }

    public WfRequester getRequesterBySession(String session) throws InvalidSessionException {
        try {
            SessionManagerFactory smf = SessionManagerFactory.getInstance();
            SessionManager sm = smf.getSessionManager();
            User user = sm.getSessionUser(session);
            Participant part = ParticipantHelper.narrow(user);
            ResourceInternal rsc = new ResourceInternal(part);
            return new GeneralRequester(rsc);
        }
        catch (Exception ex) {
            String E0146 = StringManager.get("E0146") + "(SessionID = " + session + ")";
            throw new InvalidSessionException(E0146, ex);
        }
    }

    public WfRequester getRequesterByUserID(String uid) throws InvalidSessionException {
        try {
            ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
            UserManager um = rmf.getUserManager();
            User user = um.getUser(uid);
            Participant part = ParticipantHelper.narrow(user);
            ResourceInternal rsc = new ResourceInternal(part);
            return new GeneralRequester(rsc);
        }
        catch (Exception ex) {
            String E0146 = StringManager.get("E0146") + "(UserID = " + uid + ")";
            throw new InvalidSessionException(E0146, ex);
        }
    }
}

