/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.InterWorkflowConnectorImpl;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.engine.StartProcessRequestMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorRemote;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import org.apache.log4j.Logger;

class StartProcessRequestWatcher
extends WorkflowMessageAdapter {
    private static Logger eLog = LogManager.getEngineLogger();
    public static final String NAME = "START_PROCESS_REQUEST";

    StartProcessRequestWatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(WorkflowMessage message) {
        block21: {
            if (!(message instanceof StartProcessRequestMessage)) {
                String E0099 = StringManager.get("E0099");
                eLog.error((Object)E0099);
                return;
            }
            StartProcessRequestMessage msg = (StartProcessRequestMessage)message;
            String eid = msg.getEngineID();
            String pid = msg.getProcessID();
            try {
                DataAccessManager.begin(false);
                if (eid == null || eid.trim().equals("")) {
                    ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
                    ProcessManager pm = pmf.getOwnerProcessManager(pid);
                    ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
                    StartProcessRequestWatcher startProcessRequestWatcher = this;
                    synchronized (startProcessRequestWatcher) {
                        process.start();
                        break block21;
                    }
                }
                InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(eid);
                String session = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);
                StartProcessRequestWatcher process = this;
                synchronized (process) {
                    iwc.changeProcessState(session, pid, ProcessState.OPEN_RUNNING);
                }
                iwc.disconnect(session);
            }
            catch (Exception ex) {
                try {
                    String E0100 = StringManager.get("E0100");
                    eLog.error((Object)E0100, (Throwable)ex);
                    this.abortProcess(eid, pid);
                }
                catch (Exception ex2) {
                    String F0101 = StringManager.get("F0101");
                    eLog.fatal((Object)F0101, (Throwable)ex);
                }
            }
            finally {
                try {
                    DataAccessManager.commit();
                }
                catch (Exception ex3) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortProcess(String eid, String pid) throws Exception {
        if (eid == null || eid.trim().equals("")) {
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
            proc.abort(true);
            InterWorkflowConnectorImpl iwc = (InterWorkflowConnectorImpl)InterWorkflowConnectorImpl.getInstance();
            iwc.processStateChangedLocal(pid, ProcessState.CLOSED_ABORTED);
        } else {
            InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(eid);
            String session = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);
            try {
                iwc.changeProcessState(session, pid, ProcessState.CLOSED_ABORTED);
            }
            finally {
                iwc.disconnect(session);
            }
        }
    }
}

