/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.Definition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.AuditDataRecord;
import jp.co.argo21.nautica.workflow.engine.AuditPrefix;
import jp.co.argo21.nautica.workflow.engine.AuditSuffix;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.MessageTransporter;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.engine.RequesterManager;
import jp.co.argo21.nautica.workflow.engine.SessionManagerFactory;
import jp.co.argo21.nautica.workflow.engine.StartProcessRequestMessage;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.omg.AlreadyRunningException;
import jp.co.argo21.nautica.workflow.omg.NotRunningException;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.util.StateHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;
import org.apache.log4j.Logger;

public class WorkflowEngineHandlerImpl
implements WorkflowEngineHandler {
    private static Logger eLog = LogManager.getEngineLogger();
    private static Logger audit = LogManager.getAuditLogger();

    WorkflowEngineHandlerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createProcess(String session, String pdid, String name) throws InvalidSessionException, InvalidProcessDefinitionException {
        String argInfo = "(NAUTICA API = createProcess,session = [" + session + "]," + "pdid = [" + pdid + "]," + "name = [" + name + "])";
        try {
            if (pdid == null || pdid.trim().equals("")) {
                String E0188 = StringManager.get("E0188");
                throw new InvalidProcessDefinitionException(E0188);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            RequesterManager rqm = RequesterManager.getInstance();
            WfRequester requester = rqm.getRequesterBySession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getProcessManager(pdid);
            String pid = null;
            WorkflowEngineHandlerImpl workflowEngineHandlerImpl = this;
            synchronized (workflowEngineHandlerImpl) {
                WfProcess process = pm.createProcess(requester, name);
                pid = process.getID();
            }
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMCreatedProcessInstance", session), new AuditSuffix());
            data.setDataElement("ProcessDefinitionID", pdid);
            data.setDataElement("ProcessDefinitionBusinessName", name);
            audit.info((Object)data);
            return pid;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessDefinitionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0153 = StringManager.get("E0153") + argInfo;
            eLog.error((Object)E0153, (Throwable)ex);
            throw new InvalidProcessDefinitionException(E0153, ex);
        }
    }

    public String startProcess(String session, String pid) throws InvalidSessionException, InvalidProcessInstanceException, InvalidAttributeException {
        String argInfo = "(NAUTICA API = startProcess,session = [" + session + "]," + "pid = [" + pid + "])";
        try {
            this.checkProcessID(pid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ProcessDAO procDAO = daoFactory.getProcessDAO();
            ProcessBean bean = procDAO.findByPrimaryKey(pid);
            if (bean == null) {
                String E0164 = StringManager.get("E0164");
                throw new InvalidProcessInstanceException(E0164);
            }
            ProcessState state = ProcessState.getState(bean.getProcessState());
            if (ProcessState.CLOSED_COMPLETED.equals(state) || ProcessState.CLOSED_TERMINATED.equals(state) || ProcessState.CLOSED_ABORTED.equals(state)) {
                String E0128 = StringManager.get("E0128");
                throw new NotRunningException(E0128);
            }
            if (!ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
                String E0129 = StringManager.get("E0129");
                throw new AlreadyRunningException(E0129);
            }
            StartProcessRequestMessage msg = new StartProcessRequestMessage(pid);
            WorkflowEngine engine = WorkflowEngine.getInstance();
            MessageTransporter mt = engine.getMessageTransporter(session, "START_PROCESS_REQUEST");
            mt.sendMessage(msg);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix(pid, "WMStartedProcessInstance", session), new AuditSuffix());
            audit.info((Object)data);
            return pid;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0132 = StringManager.get("E0132") + argInfo;
            eLog.error((Object)E0132, (Throwable)ex);
            throw new InvalidProcessInstanceException(E0132, ex);
        }
    }

    public void terminateProcess(String session, String pid) throws InvalidSessionException, InvalidProcessInstanceException {
        String argInfo = "(NAUTICA API = terminateProcess,session = [" + session + "]," + "pid = [" + pid + "])";
        try {
            this.checkProcessID(pid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
            proc.terminate();
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix(pid, "WMTerminatedProcessInstance", session), new AuditSuffix());
            data.setDataElement("NewProcessState", ProcessState.CLOSED_TERMINATED);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0136 = StringManager.get("E0136") + argInfo;
            eLog.error((Object)E0136, (Throwable)ex);
            throw new InvalidProcessInstanceException(E0136, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessState[] getProcessStates(String session, String pid, Filter filter) throws InvalidSessionException, InvalidProcessInstanceException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getProcessStates,session = [" + session + "]," + "pid = [" + pid + "]," + "filter = [" + filter + "])";
        ProcessState state = null;
        try {
            this.checkProcessID(pid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            if (filter != null) {
                if (!(filter instanceof StateFilter)) {
                    String E0184 = StringManager.get("E0184");
                    throw new InvalidFilterException(E0184);
                }
                WfState st = ((StateFilter)filter).getState();
                if (!(st instanceof ProcessState)) {
                    String E0205 = StringManager.get("E0205");
                    throw new InvalidFilterException(E0205);
                }
                state = (ProcessState)st;
            }
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess process = pm.getProcess(pid);
            ProcessState cstate = (ProcessState)process.getState();
            ProcessState[] tstates = null;
            tstates = state == null ? (ProcessState[])process.getTransitableStates() : (StateHelper.containsTransitable(cstate, state) ? new ProcessState[]{state} : new ProcessState[]{});
            DataAccessManager.commit();
            return tstates;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0154 = StringManager.get("E0154") + argInfo;
            eLog.error((Object)E0154, (Throwable)ex);
            throw new InvalidProcessInstanceException(E0154, ex);
        }
    }

    public void changeProcessState(String session, String pid, ProcessState state) throws InvalidSessionException, InvalidProcessInstanceException, InvalidStateException, TransitionNotAllowedException {
        String argInfo = "(NAUTICA API = changeProcessState,session = [" + session + "]," + "pid = [" + pid + "]," + "state = [" + state + "])";
        try {
            DataAccessManager.begin(false);
            this.validateSession(session);
            this.checkProcessID(pid);
            if (state == null) {
                String E0063 = StringManager.get("E0063");
                throw new InvalidStateException(E0063);
            }
            if (ProcessState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
                String E0064 = StringManager.get("E0064");
                throw new InvalidStateException(E0064);
            }
            if (ProcessState.CLOSED_COMPLETED.equals(state)) {
                String E0065 = StringManager.get("E0065");
                throw new InvalidStateException(E0065);
            }
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess process = pm.getProcess(pid);
            process.changeState(state);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix(pid, "WMChangedProcessInstanceState", session), new AuditSuffix());
            data.setDataElement("NewProcessState", state);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidStateException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0156 = StringManager.get("E0156") + argInfo;
            eLog.error((Object)E0156, (Throwable)ex);
            throw new InvalidProcessInstanceException(E0156, ex);
        }
    }

    public Attribute[] getProcessAttributes(String session, String pid, Filter filter) throws InvalidSessionException, InvalidProcessInstanceException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getProcessAttributes,session = [" + session + "]," + "pid = [" + pid + "]," + "filter = [" + filter + "])";
        try {
            this.checkProcessID(pid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
            Attribute[] attrs = (Attribute[])process.getContext(filter);
            DataAccessManager.commit();
            return attrs;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0032 = StringManager.get("E0032") + argInfo;
            eLog.error((Object)E0032, (Throwable)ex);
            throw new InvalidProcessInstanceException(E0032, ex);
        }
    }

    public Attribute getProcessAttributeValue(String session, String pid, String name) throws InvalidSessionException, InvalidAttributeException {
        String argInfo = "(NAUTICA API = getProcessAttributeValue,session = [" + session + "]," + "pid = [" + pid + "]," + "name = [" + name + "])";
        try {
            if (pid == null || pid.trim().equals("")) {
                String E0189 = StringManager.get("E0189");
                throw new InvalidAttributeException(E0189);
            }
            if (name == null || name.trim().equals("")) {
                String E0198 = StringManager.get("E0198");
                throw new InvalidAttributeException(E0198);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess process = pm.getProcess(pid);
            Attribute attr = (Attribute)process.getContext(name);
            DataAccessManager.commit();
            return attr;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0032 = StringManager.get("E0032") + argInfo;
            eLog.error((Object)E0032, (Throwable)ex);
            throw new InvalidAttributeException(E0032, ex);
        }
    }

    public void assignProcessAttribute(String session, String pid, Attribute attr) throws InvalidSessionException, InvalidProcessInstanceException, InvalidAttributeException, AttributeAssignmentFailedException {
        String argInfo = "(NAUTICA API = assignProcessAttribute,session = [" + session + "]," + "pid = [" + pid + "]," + "attr = [" + attr + "])";
        try {
            this.checkProcessID(pid);
            if (attr == null) {
                String E0131 = StringManager.get("E0131");
                throw new InvalidAttributeException(E0131);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess process = pm.getProcess(pid);
            process.setContext(attr);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix(pid, "WMAssignedProcessInstanceAttributes", session), new AuditSuffix());
            data.setDataElement("AttributeName", attr.getName());
            data.setDataElement("AttributeType", attr.getType());
            data.setDataElement("NewAttributeValue", attr.getValue());
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (AttributeAssignmentFailedException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0080 = StringManager.get("E0080") + argInfo;
            eLog.error((Object)E0080, (Throwable)ex);
            throw new InvalidAttributeException(E0080, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActivityState[] getActivityStates(String session, String pid, String aid, Filter filter) throws InvalidSessionException, InvalidProcessInstanceException, InvalidActivityInstanceException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getActivityStates,session = [" + session + "]," + "pid = [" + pid + "]," + "aid = [" + aid + "]," + "filter = [" + filter + "])";
        ActivityState state = null;
        try {
            ProcessManagerFactory pmf;
            ProcessManager pm;
            WfProcess process;
            WfActivity activity;
            this.checkProcessID(pid);
            this.checkActivityID(aid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            if (filter != null) {
                if (!(filter instanceof StateFilter)) {
                    String E0184 = StringManager.get("E0184");
                    throw new InvalidFilterException(E0184);
                }
                WfState st = ((StateFilter)filter).getState();
                if (!(st instanceof ActivityState)) {
                    String E0206 = StringManager.get("E0206");
                    throw new InvalidFilterException(E0206);
                }
                state = (ActivityState)st;
            }
            if ((activity = (process = (pm = (pmf = ProcessManagerFactory.getInstance()).getOwnerProcessManager(pid)).getProcess(pid)).getStep(aid)) == null) {
                String msg = StringManager.get("E0069");
                throw new InvalidActivityInstanceException(msg);
            }
            ActivityState cstate = (ActivityState)activity.getState();
            ActivityState[] tstates = null;
            tstates = state == null ? (ActivityState[])activity.getTransitableStates() : (StateHelper.containsTransitable(cstate, state) ? new ActivityState[]{state} : new ActivityState[]{});
            DataAccessManager.commit();
            return tstates;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidActivityInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0200 = StringManager.get("E0200") + argInfo;
            eLog.error((Object)E0200, (Throwable)ex);
            throw new InvalidActivityInstanceException(E0200, ex);
        }
    }

    public void changeActivityState(String session, String pid, String aid, ActivityState state) throws InvalidSessionException, InvalidProcessInstanceException, InvalidActivityInstanceException, InvalidStateException, TransitionNotAllowedException {
        String argInfo = "(NAUTICA API = changeActivityState,session = [" + session + "]," + "pid = [" + pid + "]," + "aid = [" + aid + "]," + "state = [" + state + "])";
        try {
            this.checkProcessID(pid);
            this.checkActivityID(aid);
            if (state == null) {
                String msg = StringManager.get("E0066");
                throw new InvalidStateException(msg);
            }
            if (ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
                String msg = StringManager.get("E0067");
                throw new InvalidStateException(msg);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess process = pm.getProcess(pid);
            WfActivity activity = process.getStep(aid);
            if (activity == null) {
                String msg = StringManager.get("E0069");
                throw new InvalidActivityInstanceException(msg);
            }
            activity.changeState(state);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix(pid, "WMChangedActivityInstanceState", session), new AuditSuffix());
            data.setDataElement("ActivityInstanceID", aid);
            data.setDataElement("ActivityDefinitionBusinessName", activity.getName());
            data.setDataElement("NewActivityState", state);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidActivityInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidStateException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0157 = StringManager.get("E0157") + argInfo;
            eLog.error((Object)E0157, (Throwable)ex);
            throw new TransitionNotAllowedException(E0157, ex);
        }
    }

    public Attribute[] getActivityAttributes(String session, String pid, String aid, Filter filter) throws InvalidSessionException, InvalidProcessInstanceException, InvalidActivityInstanceException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getActivityAttributes,session = [" + session + "]," + "pid = [" + pid + "]," + "aid = [" + aid + "]," + "filter = [" + filter + "])";
        try {
            this.checkProcessID(pid);
            this.checkActivityID(aid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess process = pm.getProcess(pid);
            ActivityInternal activity = (ActivityInternal)process.getStep(aid);
            if (activity == null) {
                String msg = StringManager.get("E0069");
                throw new InvalidActivityInstanceException(msg);
            }
            Attribute[] attrs = (Attribute[])activity.getContext(filter);
            DataAccessManager.commit();
            return attrs;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidActivityInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0201 = StringManager.get("E0201") + argInfo;
            eLog.error((Object)E0201, (Throwable)ex);
            throw new InvalidProcessInstanceException(E0201, ex);
        }
    }

    public Attribute getActivityAttributeValue(String session, String pid, String aid, String name) throws InvalidSessionException, InvalidAttributeException {
        String argInfo = "(NAUTICA API = getActivityAttributeValue,session = [" + session + "]," + "pid = [" + pid + "]," + "aid = [" + aid + "]," + "name = [" + name + "])";
        try {
            if (pid == null || pid.trim().equals("")) {
                String E0189 = StringManager.get("E0189");
                throw new InvalidAttributeException(E0189);
            }
            if (aid == null || aid.trim().equals("")) {
                String E0197 = StringManager.get("E0197");
                throw new InvalidAttributeException(E0197);
            }
            if (name == null || name.trim().equals("")) {
                String E0198 = StringManager.get("E0198");
                throw new InvalidAttributeException(E0198);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess process = pm.getProcess(pid);
            WfActivity activity = process.getStep(aid);
            if (activity == null) {
                String msg = StringManager.get("E0069");
                throw new InvalidActivityInstanceException(msg);
            }
            Attribute attr = (Attribute)activity.getContext(name);
            DataAccessManager.commit();
            return attr;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0201 = StringManager.get("E0201") + argInfo;
            eLog.error((Object)E0201, (Throwable)ex);
            throw new InvalidAttributeException(E0201, ex);
        }
    }

    public void assignActivityAttribute(String session, String pid, String aid, Attribute attr) throws InvalidSessionException, InvalidProcessInstanceException, InvalidActivityInstanceException, InvalidAttributeException, AttributeAssignmentFailedException {
        String argInfo = "(NAUTICA API = assignActivityAttribute,session = [" + session + "]," + "pid = [" + pid + "]," + "aid = [" + aid + "]," + "attr = [" + attr + "])";
        try {
            this.checkProcessID(pid);
            this.checkActivityID(aid);
            if (attr == null) {
                String E0131 = StringManager.get("E0131");
                throw new InvalidAttributeException(E0131);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess process = pm.getProcess(pid);
            WfActivity activity = process.getStep(aid);
            if (activity == null) {
                String msg = StringManager.get("E0069");
                throw new InvalidActivityInstanceException(msg);
            }
            activity.setContext(attr);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix(pid, "WMAssignedActivityInstanceAttributes", session), new AuditSuffix());
            data.setDataElement("ActivityInstanceID", aid);
            data.setDataElement("ActivityState", activity.getState());
            data.setDataElement("AttributeName", attr.getName());
            data.setDataElement("AttributeType", attr.getType());
            data.setDataElement("NewAttributeValue", attr.getValue());
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidActivityInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (AttributeAssignmentFailedException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0158 = StringManager.get("E0158") + argInfo;
            eLog.error((Object)E0158, (Throwable)ex);
            throw new InvalidAttributeException(E0158, ex);
        }
    }

    public Process[] getProcesses(String session, Filter filter) throws InvalidSessionException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getProcesses,session = [" + session + "]," + "filter = [" + filter + "])";
        try {
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            Process[] procs = pmf.getProcesses(filter);
            DataAccessManager.commit();
            return procs;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0199 = StringManager.get("E0199");
            eLog.error((Object)E0199, (Throwable)ex);
            throw new InvalidFilterException(E0199, ex);
        }
    }

    public Process getProcess(String session, String pid) throws InvalidSessionException, InvalidProcessInstanceException {
        String argInfo = "(NAUTICA API = getProcess,session = [" + session + "]," + "pid = [" + pid + "])";
        try {
            this.checkProcessID(pid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal internal = (ProcessInternal)pm.getProcess(pid);
            DataAccessManager.commit();
            return internal.getBean();
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0151 = StringManager.get("E0151") + argInfo;
            eLog.error((Object)E0151, (Throwable)ex);
            throw new InvalidProcessInstanceException(E0151, ex);
        }
    }

    public Activity[] getActivities(String session, Filter filter) throws InvalidSessionException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getActivities,session = [" + session + "]," + "filter = [" + filter + "])";
        try {
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            Activity[] acts = pmf.getActivities(filter);
            DataAccessManager.commit();
            return acts;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0202 = StringManager.get("E0202") + argInfo;
            eLog.error((Object)E0202, (Throwable)ex);
            throw new InvalidFilterException(E0202, ex);
        }
    }

    public Activity[] getActivities(String session, String pid, Filter filter) throws InvalidSessionException, InvalidFilterException {
        String argInfo = "(NAUTICA API = getActivities,session = [" + session + "]," + "pid = [" + pid + "]," + "filter = [" + filter + "])";
        try {
            if (pid == null || pid.trim().equals("")) {
                String E0189 = StringManager.get("E0189");
                throw new InvalidFilterException(E0189);
            }
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
            Activity[] acts = process.getActivities(filter);
            DataAccessManager.commit();
            return acts;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0202 = StringManager.get("E0202") + argInfo;
            eLog.error((Object)E0202, (Throwable)ex);
            throw new InvalidFilterException(E0202, ex);
        }
    }

    public Activity getActivity(String session, String pid, String aid) throws InvalidSessionException, InvalidProcessInstanceException, InvalidActivityInstanceException {
        String argInfo = "(NAUTICA API = getActivity,session = [" + session + "]," + "pid = [" + pid + "]," + "aid = [" + aid + "])";
        try {
            this.checkProcessID(pid);
            this.checkActivityID(aid);
            DataAccessManager.begin(false);
            this.validateSession(session);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess proc = pm.getProcess(pid);
            ActivityInternal internal = (ActivityInternal)proc.getStep(aid);
            if (internal == null) {
                String E0203 = StringManager.get("E0203");
                throw new InvalidActivityInstanceException(E0203);
            }
            ActivityBean bean = internal.getBean();
            DataAccessManager.commit();
            return bean;
        }
        catch (InvalidSessionException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidProcessInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (InvalidActivityInstanceException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0124 = StringManager.get("E0124") + argInfo;
            eLog.error((Object)E0124, (Throwable)ex);
            throw new InvalidActivityInstanceException(E0124, ex);
        }
    }

    private void rollbackAndLogging(Exception ex, String argInfo) {
        try {
            DataAccessManager.rollback();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        String msg = ex.getMessage() + argInfo;
        eLog.error((Object)msg, (Throwable)ex);
    }

    private void checkProcessID(String pid) throws InvalidProcessInstanceException {
        if (pid == null || pid.trim().equals("")) {
            String E0189 = StringManager.get("E0189");
            throw new InvalidProcessInstanceException(E0189);
        }
    }

    private void checkActivityID(String aid) throws InvalidActivityInstanceException {
        if (aid == null || aid.trim().equals("")) {
            String E0197 = StringManager.get("E0197");
            throw new InvalidActivityInstanceException(E0197);
        }
    }

    private void validateSession(String session) throws InvalidSessionException {
        if (session == null || session.trim().equals("")) {
            String E0170 = StringManager.get("E0170");
            throw new InvalidSessionException(E0170);
        }
        SessionManagerFactory factory = SessionManagerFactory.getInstance();
        SessionManager manager = factory.getSessionManager();
        manager.validateSession(session);
    }

    private ActivityDefinition findActivity(ProcessDefinition pd, String adid) throws Exception {
        List acts = pd.getActivities();
        Iterator it = acts.iterator();
        Definition ad = null;
        while (it.hasNext()) {
            ActivityDefinition def = (ActivityDefinition)it.next();
            if (!ad.getID().equals(adid)) continue;
            ad = def;
            break;
        }
        if (ad == null) {
            String E0204 = StringManager.get("E0204");
            throw new WorkflowException(E0204);
        }
        return ad;
    }
}

