/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import java.util.HashMap;
import java.util.Map;
import jp.co.argo21.nautica.workflow.ta.config.App;
import jp.co.argo21.nautica.workflow.ta.config.Auth;
import jp.co.argo21.nautica.workflow.ta.config.MailDocument;
import jp.co.argo21.nautica.workflow.ta.config.Receiver;
import jp.co.argo21.nautica.workflow.ta.config.Server;
import jp.co.argo21.nautica.workflow.ta.config.Servers;

public class MailConfig {
    private String user = null;
    private String password = null;
    private Map applications = new HashMap();

    MailConfig(MailDocument.Mail mali) {
        this.user = mali.getAuthentication().getUser();
        this.password = mali.getAuthentication().getPassword();
        Servers serverlist = mali.getServers();
        if (serverlist == null) {
            return;
        }
        Server[] servers = serverlist.getServerArray();
        for (int i = 0; i < servers.length; ++i) {
            Server server = servers[i];
            App[] apps = servers[i].getAppArray();
            for (int j = 0; j < apps.length; ++j) {
                this.applications.put(apps[j].getName(), server);
            }
        }
    }

    private Server getServer(String appName) {
        return (Server)this.applications.get(appName);
    }

    public String getAuthType(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getAuthType();
    }

    public String getSenderProtocol(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getSender().getProtocol();
    }

    public String getSenderEncode(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getSender().getEncode();
    }

    public String getSenderMimeType(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getSender().getMimeType();
    }

    public String getSenderHostAddress(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        return server.getSender().getHost().getAddress();
    }

    public int getSenderHostPort(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return -1;
        }
        return server.getSender().getHost().getPort();
    }

    public String getSenderHostUser(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        Auth auth = server.getSender().getAuthentication();
        if (auth == null) {
            return null;
        }
        return auth.getUser();
    }

    public String getSenderHostPassword(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        Auth auth = server.getSender().getAuthentication();
        if (auth == null) {
            return null;
        }
        return auth.getPassword();
    }

    public String getReceiverProtocol(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return null;
        }
        return receiver.getProtocol();
    }

    public String getReceiverHostAddress(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return null;
        }
        return receiver.getHost().getAddress();
    }

    public int getReceiverHostPort(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return -1;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return -1;
        }
        return receiver.getHost().getPort();
    }

    public String getReceiverHostUser(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return null;
        }
        return receiver.getAuthentication().getUser();
    }

    public String getReceiverHostPassword(String appName) {
        Server server = this.getServer(appName);
        if (server == null) {
            return null;
        }
        Receiver receiver = server.getReceiver();
        if (receiver == null) {
            return null;
        }
        return receiver.getAuthentication().getPassword();
    }

    public boolean existApplication(String appName) {
        return this.applications.containsKey(appName);
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }
}

