/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.ta.ScriptingConfig;
import jp.co.argo21.nautica.workflow.ta.config.ScriptingDocument;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.xmlbeans.XmlOptions;

public class ScriptingConfigFactory {
    public static String CONFIG_FILENAME = "scriptingconfig.xml";
    private static long lastModified = 0L;
    private static ScriptingConfig config = null;

    private ScriptingConfigFactory() {
    }

    public static synchronized ScriptingConfig getConfig() throws WorkflowException {
        try {
            File configFile = new File(ScriptingConfigFactory.getConfigPath());
            if (config == null || lastModified < configFile.lastModified()) {
                FileInputStream in = new FileInputStream(configFile);
                XmlOptions opts = new XmlOptions();
                opts.setCharacterEncoding("utf-8");
                ScriptingDocument doc = ScriptingDocument.Factory.parse((InputStream)in, (XmlOptions)opts);
                ScriptingDocument.Scripting scripting = doc.getScripting();
                config = new ScriptingConfig(scripting);
                lastModified = configFile.lastModified();
            }
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E2005");
            throw new WorkflowException(errMsg, ex);
        }
        return config;
    }

    private static URI getConfigPath() throws WorkflowException {
        String home = System.getProperty("nautica.home");
        String conf = CONFIG_FILENAME;
        String separator = System.getProperty("file.separator");
        String path = home + separator + "config" + separator + conf;
        File confFile = new File(path);
        if (!confFile.exists()) {
            throw new WorkflowException(path + " is not found.");
        }
        if (!confFile.isFile()) {
            throw new WorkflowException(path + " is not file.");
        }
        return confFile.toURI();
    }
}

