/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lib;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import pnuts.lang.AbstractData;
import pnuts.lang.Context;
import pnuts.lang.Implementation;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsImpl;

public class ScriptPackage
extends Package
implements AbstractData {
    private static Implementation pureImpl = new PnutsImpl();
    private static final String PRINT_FUNCTION = "print".intern();

    public ScriptPackage() {
    }

    public ScriptPackage(String name) {
        this(name, null);
    }

    public ScriptPackage(String name, Package parent) {
        super(name, parent, null);
    }

    public Object invoke(String name, Object[] args, Context context) {
        Object o = this.get(name, context);
        if (o instanceof PnutsFunction) {
            return ((PnutsFunction)o).call(args, context);
        }
        if (o instanceof Class) {
            return context.getConfiguration().callConstructor(context, (Class)o, args, null);
        }
        throw new PnutsException("funcOrType.expected", new Object[]{Pnuts.format((Object)o)}, context);
    }

    public PnutsFunction getPrintFunction() {
        PnutsFunction f;
        Object o = this.get(PRINT_FUNCTION);
        if (o instanceof PnutsFunction && (f = (PnutsFunction)o).defined(0)) {
            return f;
        }
        return null;
    }

    public String toString() {
        PnutsFunction printFunction = this.getPrintFunction();
        if (printFunction != null) {
            Context context = new Context();
            StringWriter sw = new StringWriter();
            context.setWriter((Writer)sw);
            printFunction.call(new Object[0], context);
            return sw.toString();
        }
        return "<script package>";
    }

    public static class Function
    extends PnutsFunction
    implements AbstractData {
        private Package prototype;

        public Function() {
            this("$");
        }

        public Function(String name) {
            this(name, new ScriptPackage(null, null));
        }

        public Function(String name, Package prototype) {
            super(name);
            this.prototype = prototype;
        }

        public Object get(String name, Context context) {
            return null;
        }

        public void set(String name, Object value, Context context) {
        }

        public Object invoke(String name, Object[] args, Context context) {
            if ("call".equals(name)) {
                return this.call(args, context);
            }
            if ("set".equals(name)) {
                if (args.length == 3) {
                    Package pkg = (Package)args[0];
                    String sym = (String)args[1];
                    Object value = args[2];
                    pkg.set(sym.intern(), value, context);
                    return null;
                }
            } else if ("get".equals(name)) {
                if (args.length == 2) {
                    Package pkg = (Package)args[0];
                    String sym = (String)args[1];
                    return pkg.get(sym.intern(), context);
                }
            } else if ("clear".equals(name)) {
                if (args.length == 2) {
                    Package pkg = (Package)args[0];
                    String sym = (String)args[1];
                    pkg.clear(sym.intern(), context);
                    return null;
                }
            } else if ("defined".equals(name)) {
                if (args.length == 2) {
                    Package pkg = (Package)args[0];
                    String sym = (String)args[1];
                    boolean b = pkg.defined(sym.intern(), context);
                    return b ? Boolean.TRUE : Boolean.FALSE;
                }
            } else if ("keys".equals(name)) {
                if (args.length == 1) {
                    Package pkg = (Package)args[0];
                    return pkg.keys();
                }
            } else if ("clone".equals(name)) {
                if (args.length == 1) {
                    Package pkg = (Package)args[0];
                    return pkg.clone();
                }
            } else if ("save".equals(name) && args.length == 2) {
                Package pkg = (Package)args[0];
                try {
                    ObjectOutputStream o = new ObjectOutputStream((OutputStream)args[1]);
                    o.writeObject(pkg);
                    return null;
                }
                catch (IOException e) {
                    throw new PnutsException((Throwable)e, context);
                }
            }
            throw new PnutsException("method.notFound", new Object[]{name, this.toString(), "" + Pnuts.format((Object)args)}, context);
        }

        public boolean defined(int nargs) {
            return nargs >= -1;
        }

        protected Object exec(Object[] args, Context context) {
            if (args.length == 0) {
                return this.prototype.clone();
            }
            if (args.length == 1 && args[0] instanceof String) {
                Context c = new Context(context);
                c.setImplementation(pureImpl);
                Package p = (Package)this.prototype.clone();
                c.setCurrentPackage(p);
                Pnuts.eval((String)((String)args[0]), (Context)c);
                return p;
            }
            if (args.length == 1 && args[0] instanceof Object[]) {
                Object[] list2 = (Object[])args[0];
                Package sp = (Package)this.prototype.clone();
                for (int i = 0; i < list2.length; ++i) {
                    Object[] pair = (Object[])list2[i];
                    String name = (String)pair[0];
                    sp.set(name.intern(), pair[1], context);
                }
                return sp;
            }
            Package sp = (Package)this.prototype.clone();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!(arg instanceof PnutsFunction)) continue;
                String name = ((PnutsFunction)arg).getName();
                int idx = name.lastIndexOf(46);
                if (idx >= 0) {
                    name = name.substring(idx + 1);
                }
                sp.set(name.intern(), arg, context);
            }
            return sp;
        }
    }
}

