/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pnuts.compiler.ClassFile;
import pnuts.compiler.ClassFileHandler;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lib.BeanClassGenerator;
import pnuts.lib.ClassFileLoader;
import pnuts.lib.SubtypeGenerator;
import pnuts.lib.subclass;

class beanclass
extends PnutsFunction {
    private ClassFileHandler handler;

    public beanclass() {
        this(null);
    }

    public beanclass(ClassFileHandler handler) {
        super("beanclass");
        this.handler = handler;
    }

    public boolean defined(int nargs) {
        return nargs == 3 || nargs == 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object exec(Object[] args, Context context) {
        String[] constructorParams;
        int nargs = args.length;
        if (nargs != 3 && nargs != 4) {
            this.undefined(args, context);
            return null;
        }
        String className = (String)args[0];
        Object supertypes = args[1];
        ArrayList list2 = new ArrayList();
        Class superclass = subclass.parseSupertypes(supertypes, list2, context);
        String[] superInterfaces = new String[list2.size()];
        for (int i = 0; i < superInterfaces.length; ++i) {
            Class type = (Class)list2.get(i);
            superInterfaces[i] = type.getName();
        }
        Map typeMap = (Map)args[2];
        if (args.length == 4) {
            Object arg3 = args[3];
            if (arg3 instanceof String[]) {
                constructorParams = (String[])arg3;
            } else if (arg3 instanceof Object[]) {
                int len = ((Object[])arg3).length;
                constructorParams = new String[len];
                System.arraycopy(arg3, 0, constructorParams, 0, len);
            } else {
                if (!(arg3 instanceof List)) throw new IllegalArgumentException(String.valueOf(arg3));
                List lst = (List)arg3;
                int len = lst.size();
                constructorParams = new String[len];
                for (int i = 0; i < len; ++i) {
                    constructorParams[i] = (String)lst.get(i);
                }
            }
        } else {
            constructorParams = null;
        }
        try {
            if (this.handler == null) {
                Class[] types = new Class[list2.size() + 1];
                types[0] = superclass;
                for (int i = 0; i < list2.size(); ++i) {
                    types[i + 1] = (Class)list2.get(i);
                }
                ClassLoader cl = SubtypeGenerator.mergeClassLoader(types, context.getClassLoader());
                this.handler = new ClassFileLoader(cl);
                context.setClassLoader((ClassLoader)this.handler);
            }
            ClassFile cf = BeanClassGenerator.generateClassFile(typeMap, className, superclass.getName(), superInterfaces, constructorParams);
            return this.handler.handle(cf);
        }
        catch (Exception e) {
            throw new PnutsException((Throwable)e, context);
        }
    }

    public String toString() {
        return "function beanclass(className, superInterfaces, typeMap {, constructorParams[] })";
    }
}

