/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lib;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

class getInetAddress
extends PnutsFunction {
    public getInetAddress() {
        super("getInetAddress");
    }

    public boolean defined(int nargs) {
        return nargs == 1 || nargs == 2;
    }

    static InetAddress getInetAddress(String hostName, String address) throws UnknownHostException {
        StringTokenizer st = new StringTokenizer(address, ".");
        if (st.countTokens() == 4) {
            try {
                byte[] bytes = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    bytes[i] = (byte)Integer.parseInt(st.nextToken());
                }
                if (hostName != address) {
                    return InetAddress.getByAddress(hostName, bytes);
                }
                return InetAddress.getByAddress(bytes);
            }
            catch (NumberFormatException num) {
                return InetAddress.getByName(hostName);
            }
        }
        return InetAddress.getByName(hostName);
    }

    protected Object exec(Object[] args, Context context) {
        int nargs = args.length;
        try {
            if (nargs == 1) {
                Object hostOrAddr = args[0];
                if (hostOrAddr instanceof InetAddress) {
                    return (InetAddress)hostOrAddr;
                }
                if (hostOrAddr instanceof String) {
                    String s = (String)hostOrAddr;
                    return getInetAddress.getInetAddress(s, s);
                }
                throw new IllegalArgumentException(String.valueOf(hostOrAddr));
            }
            if (nargs == 2) {
                String host = (String)args[0];
                String addr = (String)args[1];
                return getInetAddress.getInetAddress(host, addr);
            }
            this.undefined(args, context);
            return null;
        }
        catch (UnknownHostException e) {
            throw new PnutsException((Throwable)e, context);
        }
    }

    public String toString() {
        return "function getInetAddress(host, addr) or (hostOrAddr)";
    }
}

