/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lib;

import pnuts.lang.Context;
import pnuts.lang.PnutsFunction;

class hex
extends PnutsFunction {
    static char[] hex_chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public hex() {
        super("hex");
    }

    public boolean defined(int narg) {
        return narg == 1;
    }

    public static String hex(int val) {
        char[] buf = new char[32];
        int pos = 32;
        do {
            buf[--pos] = hex_chars[val & 0xF];
        } while ((val >>>= 4) != 0);
        return new String(buf, pos, 32 - pos);
    }

    protected Object exec(Object[] args, Context context) {
        String s;
        if (args.length != 1) {
            this.undefined(args, context);
            return null;
        }
        Object n = args[0];
        if (n instanceof Integer) {
            s = hex.hex((Integer)n);
        } else {
            if (n instanceof byte[]) {
                byte[] b = (byte[])n;
                int len = b.length;
                char[] result = new char[len * 2];
                int i = 0;
                int j = 0;
                while (i < len) {
                    byte x = b[i];
                    int q = (x + 256) % 256;
                    result[j] = hex_chars[q >> 4];
                    result[j + 1] = hex_chars[q & 0xF];
                    ++i;
                    j += 2;
                }
                return new String(result);
            }
            if (n instanceof Long) {
                long val = (Long)n;
                s = Long.toHexString(val);
            } else if (n instanceof Character) {
                s = hex.hex(((Character)n).charValue());
            } else {
                throw new IllegalArgumentException();
            }
        }
        return s;
    }

    public String toString() {
        return "function hex(Integer|Long|Character|byte[])";
    }
}

