/*
 * Decompiled with CFR 0.152.
 */
package pnuts.nio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;
    private int mark;
    private boolean eof;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buffer = buf;
    }

    public int read() throws IOException {
        if (this.eof) {
            throw new EOFException();
        }
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException e) {
            this.eof = true;
            return -1;
        }
    }

    public int read(byte[] b, int offset, int size2) throws IOException {
        if (this.eof) {
            throw new EOFException();
        }
        int oldPosition = this.buffer.position();
        int limit = this.buffer.limit();
        if (limit == oldPosition) {
            this.eof = true;
            return -1;
        }
        if (size2 > limit - oldPosition) {
            size2 = limit - oldPosition;
        }
        try {
            this.buffer.get(b, offset, size2);
            return this.buffer.position() - oldPosition;
        }
        catch (IndexOutOfBoundsException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (BufferUnderflowException e2) {
            throw new IOException(e2.getMessage());
        }
    }

    public long skip(long n) throws IOException {
        int limit;
        if (this.eof) {
            throw new EOFException();
        }
        int oldPosition = this.buffer.position();
        long newPosition = (long)oldPosition + n;
        if (newPosition > (long)(limit = this.buffer.limit())) {
            newPosition = limit;
        }
        ((Buffer)this.buffer).position((int)newPosition);
        return newPosition - (long)oldPosition;
    }

    public int available() throws IOException {
        return this.buffer.remaining();
    }

    public void close() throws IOException {
    }

    public void mark(int readlimit) {
        this.mark = this.buffer.position();
    }

    public void reset() throws IOException {
        ((Buffer)this.buffer).position(this.mark);
    }

    public boolean markSupported() {
        return true;
    }
}

