/*
 * Decompiled with CFR 0.152.
 */
package pnuts.nio;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

class CharBufferReader
extends Reader {
    private CharBuffer cbuf;
    private int length;
    private int next = 0;
    private int mark = 0;

    public CharBufferReader(CharBuffer cbuf) {
        this.cbuf = cbuf;
        this.length = cbuf.length();
    }

    private void ensureOpen() throws IOException {
        if (this.cbuf == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                return -1;
            }
            return this.cbuf.get(this.next++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] ca, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > ca.length || len < 0 || off + len > ca.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.next >= this.length) {
                return -1;
            }
            int n = Math.min(this.length - this.next, len);
            this.cbuf.get(ca, off, n);
            this.next += n;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long ns) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                return 0L;
            }
            long n = Math.min((long)(this.length - this.next), ns);
            this.next = (int)((long)this.next + n);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return true;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mark = this.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.next = this.mark;
        }
    }

    public void close() {
        this.cbuf = null;
    }
}

