/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet.protocol.pea;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import pnuts.lang.Context;
import pnuts.servlet.DynamicPage;

public class DynamicPageURLConnection
extends URLConnection {
    private URL specURL;
    private URLConnection specURLConnection;
    private File dir;
    private String encoding;
    private boolean connected;
    private Context context;

    public DynamicPageURLConnection(URL url, Context context) throws IOException {
        super(url);
        this.context = context;
        this.parseSpecs(url);
    }

    private void parseSpecs(URL url) throws MalformedURLException {
        String spec = url.getFile();
        int idx = spec.indexOf(33);
        if (idx > 0) {
            this.specURL = new URL(spec.substring(0, idx));
            if (spec.length() > idx + 1 && spec.startsWith("charset=", idx + 1)) {
                this.encoding = spec.substring(idx + 9);
            }
        } else {
            this.specURL = new URL(spec);
        }
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return "application/pnuts-dynamic-page";
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.specURLConnection = this.specURL.openConnection();
        this.specURLConnection.connect();
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        InputStreamReader reader2 = this.encoding == null ? new InputStreamReader(this.specURLConnection.getInputStream()) : new InputStreamReader(this.specURLConnection.getInputStream(), this.encoding);
        StringWriter writer2 = new StringWriter();
        DynamicPage.convert(reader2, writer2, this.dir, this.encoding, this.context);
        return new ByteArrayInputStream(writer2.toString().getBytes());
    }
}

