/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import pnuts.compiler.Compiler;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Runtime;
import pnuts.servlet.DynamicPage;
import pnuts.servlet.protocol.pea.Handler;

class readDynamicPage
extends PnutsFunction {
    private static final String SERVLET_COMPILER = "pnuts.servlet.compiler".intern();

    public readDynamicPage() {
        super("readDynamicPage");
    }

    public boolean defined(int nargs) {
        return nargs == 1 || nargs == 2;
    }

    static URL getDynamicPageURL(URL url, String encoding, Context context) {
        try {
            String specURL = encoding == null ? "pea:" + url.toExternalForm() : "pea:" + url.toExternalForm() + "!charset=" + encoding;
            return new URL(null, specURL, new Handler(context));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return null;
        }
    }

    static Reader getReader(InputStream in, String enc, Context context) throws UnsupportedEncodingException {
        if (enc != null) {
            return new InputStreamReader(in, enc);
        }
        return Runtime.getScriptReader((InputStream)in, (Context)context);
    }

    protected Object exec(Object[] args, Context context) {
        int nargs = args.length;
        if (nargs != 1 && nargs != 2) {
            this.undefined(args, context);
        }
        Object arg = args[0];
        String encoding = nargs == 2 ? (String)args[1] : context.getScriptEncoding();
        Pnuts parsed = null;
        URL url = null;
        Reader reader2 = null;
        Reader readerToClose = null;
        Compiler compiler = (Compiler)context.get(SERVLET_COMPILER);
        try {
            if (arg instanceof InputStream) {
                reader2 = readDynamicPage.getReader((InputStream)arg, encoding, context);
            } else if (arg instanceof Reader) {
                reader2 = (Reader)arg;
            } else if (arg instanceof URL) {
                url = (URL)arg;
                reader2 = readerToClose = readDynamicPage.getReader(url.openStream(), encoding, context);
            } else if (arg instanceof File) {
                File file = (File)arg;
                url = file.toURL();
                reader2 = readerToClose = readDynamicPage.getReader(new FileInputStream(file), encoding, context);
            } else if (arg instanceof String) {
                url = Pnuts.getResource((String)((String)arg), (Context)context);
                reader2 = readerToClose = readDynamicPage.getReader(url.openStream(), encoding, context);
            } else {
                throw new IllegalArgumentException(String.valueOf(arg));
            }
            URL scriptURL = null;
            if (url != null) {
                scriptURL = readDynamicPage.getDynamicPageURL(url, encoding, context);
            }
            StringWriter sw = new StringWriter();
            DynamicPage.convert(reader2, sw, null, encoding, context);
            parsed = Pnuts.parse((Reader)new StringReader(sw.toString()), (Object)scriptURL, (Context)context);
            if (compiler != null) {
                parsed = compiler.compile(parsed, context);
            }
            Pnuts pnuts = parsed;
            return pnuts;
        }
        catch (Throwable t) {
            throw new PnutsException(t, context);
        }
        finally {
            if (readerToClose != null) {
                try {
                    readerToClose.close();
                }
                catch (IOException e) {
                    throw new PnutsException((Throwable)e, context);
                }
            }
        }
    }

    public String toString() {
        return "function readDynamicPage((String|InputStream|Reader|File|URL) input {, encoding })";
    }
}

