/*
 * Decompiled with CFR 0.152.
 */
package pnuts.text;

import java.io.IOException;

public abstract class AbstractLineReader {
    protected static int defaultCharBufferSize = 8192;
    protected char[] cb;
    protected int size;
    protected int startChar;
    private boolean stopped = false;

    protected AbstractLineReader(int sz) {
        if (sz <= 0) {
            throw new IllegalArgumentException();
        }
        this.cb = new char[sz];
    }

    protected AbstractLineReader() {
        this(defaultCharBufferSize);
    }

    protected abstract int fill(char[] var1, int var2, int var3) throws IOException;

    protected void process(char[] c, int offset, int length) {
    }

    boolean fillBuffer() throws IOException {
        int n = 0;
        int offset = this.size - this.startChar;
        if (offset < 0) {
            return false;
        }
        do {
            if (this.startChar > 0 && this.startChar < this.cb.length) {
                System.arraycopy(this.cb, this.startChar, this.cb, 0, offset);
                continue;
            }
            if (offset != this.cb.length) continue;
            char[] newarray = new char[this.cb.length * 2];
            System.arraycopy(this.cb, this.startChar, newarray, 0, offset);
            this.cb = newarray;
        } while ((n = this.fill(this.cb, offset, this.cb.length - offset)) == 0);
        if (n > 0) {
            this.size = n + offset;
        }
        return n > 0;
    }

    public synchronized boolean processLine(boolean includeNewLine) throws IOException {
        int e;
        int n = 0;
        int startChar = this.startChar;
        if (this.size < 1) {
            this.fillBuffer();
        }
        while (true) {
            boolean eol = false;
            boolean cr = false;
            char c = '\u0000';
            int size2 = this.size;
            int i = e = startChar + n;
            while (i < size2) {
                c = this.cb[i++];
                ++n;
                if (c == '\n') {
                    eol = true;
                    if (!includeNewLine) break;
                    ++e;
                    break;
                }
                if (c == '\r') {
                    eol = true;
                    if (cr) {
                        --n;
                        break;
                    }
                    if (includeNewLine) {
                        ++e;
                    }
                    cr = true;
                    if (i != size2) continue;
                    if (this.fillBuffer()) {
                        e -= startChar;
                        startChar = 0;
                        this.startChar = 0;
                        size2 = this.size;
                        i = n;
                        continue;
                    }
                    if (i > startChar) {
                        this.process(this.cb, startChar, e - startChar);
                    }
                    return false;
                }
                if (cr) {
                    --n;
                    break;
                }
                ++e;
                cr = false;
            }
            if (eol) {
                if (e >= startChar) {
                    this.process(this.cb, startChar, e - startChar);
                }
                this.startChar += n;
                return true;
            }
            if (!this.fillBuffer()) break;
            e -= startChar;
            startChar = 0;
            this.startChar = 0;
            size2 = this.size;
            i = n;
        }
        if (e > startChar) {
            this.process(this.cb, startChar, e - startChar);
        }
        return false;
    }

    public void stop() {
        this.stopped = true;
    }

    public int processAll() throws IOException {
        return this.processAll(false);
    }

    public int processAll(boolean includeNewLine) throws IOException {
        int count2 = 0;
        while (!this.stopped && this.processLine(includeNewLine)) {
            ++count2;
        }
        return count2;
    }
}

