/*
 * Decompiled with CFR 0.152.
 */
package pnuts.xml;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import pnuts.xml.DigestAction;
import pnuts.xml.RuleSet;
import pnuts.xml.RuleTarget;
import pnuts.xml.TargetHandler;

class DefaultRuleSet
implements RuleSet {
    private static Comparator patternNodeComparator = new PatternNodeComparator();
    private PatternNode rootNode = new PatternNode();
    private PatternNode reverseNodes = new PatternNode();
    private int count = 0;

    DefaultRuleSet() {
    }

    private void addForwardPattern(String pattern, RuleTarget value) {
        int idx;
        PatternNode node = this.rootNode;
        int pos = 1;
        while ((idx = pattern.indexOf(47, pos)) >= 0) {
            String s = pattern.substring(pos, idx);
            if (s.equals("*")) {
                node.wildcardNode = new PatternNode();
            } else if (!node.containsKey(s)) {
                PatternNode patternNode = node;
                node = new PatternNode();
                patternNode.put(s, node);
            } else {
                node = (PatternNode)node.get(s);
            }
            pos = idx + 1;
        }
        String s = pattern.substring(pos);
        if (s.equals("*")) {
            node.wildcardNode = node = new PatternNode();
        } else if (!node.containsKey(s)) {
            PatternNode patternNode = node;
            node = new PatternNode();
            patternNode.put(s, node);
        } else {
            node = (PatternNode)node.get(s);
        }
        node.value = value;
        node.id = ++this.count;
    }

    private void addReversePattern(String pattern, RuleTarget value) {
        int idx;
        ArrayList<String> list2 = new ArrayList<String>();
        int pos = 2;
        while ((idx = pattern.indexOf(47, pos)) >= 0) {
            list2.add(pattern.substring(pos, idx));
            pos = idx + 1;
        }
        list2.add(pattern.substring(pos));
        Collections.reverse(list2);
        PatternNode node = this.reverseNodes;
        Iterator it = ((AbstractList)list2).iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (s.equals("*")) {
                node.wildcardNode = node = new PatternNode();
                continue;
            }
            if (!node.containsKey(s)) {
                PatternNode patternNode = node;
                node = new PatternNode();
                patternNode.put(s, node);
                continue;
            }
            node = (PatternNode)node.get(s);
        }
        if (node != null) {
            node.value = value;
            node.id = ++this.count;
        }
    }

    public void add(String pattern, DigestAction action, String keyword) {
        RuleTarget value = new RuleTarget(action, keyword);
        if (pattern.startsWith("//")) {
            this.addReversePattern(pattern, value);
        } else {
            this.addForwardPattern(pattern, value);
        }
    }

    private void searchPattern(PatternNode nodes, List paths, int idx, int endIndex, boolean forward2, Set list2) {
        PatternNode n = (PatternNode)nodes.get(paths.get(idx));
        int last = paths.size();
        if (n != null) {
            if (n.id != 0) {
                list2.add(n);
            }
            if (idx != endIndex) {
                this.searchPattern(n, paths, forward2 ? idx + 1 : idx - 1, endIndex, forward2, list2);
            }
        }
        if ((n = nodes.wildcardNode) != null) {
            if (n.id != 0) {
                list2.add(n);
            }
            if (idx != endIndex) {
                this.searchPattern(n, paths, forward2 ? idx + 1 : idx - 1, endIndex, forward2, list2);
            }
        }
    }

    public void scan(String path, List paths, TargetHandler handler) throws Exception {
        TreeSet nodeSet = new TreeSet(patternNodeComparator);
        int pathSize = paths.size();
        this.searchPattern(this.rootNode, paths, 0, pathSize - 1, true, nodeSet);
        this.searchPattern(this.reverseNodes, paths, pathSize - 1, 0, false, nodeSet);
        Iterator it = nodeSet.iterator();
        while (it.hasNext()) {
            PatternNode node = (PatternNode)it.next();
            if (node.id <= 0) continue;
            RuleTarget rule = node.value;
            handler.handle(rule.action, rule.keyword);
        }
    }

    static class PatternNodeComparator
    implements Comparator {
        PatternNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            PatternNode p1 = (PatternNode)o1;
            PatternNode p2 = (PatternNode)o2;
            return p1.id - p2.id;
        }
    }

    static class PatternNode
    extends HashMap {
        RuleTarget value;
        int id;
        PatternNode wildcardNode;

        PatternNode() {
        }
    }
}

