/*
 * Decompiled with CFR 0.152.
 */
package pnuts.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pnuts.xml.DefaultRuleSet;
import pnuts.xml.DigestAction;
import pnuts.xml.DigestHandler;
import pnuts.xml.SimpleRuleSet;

public class DigestReader
extends DigestHandler {
    private SAXParser parser;
    private Map aliasMap = new HashMap();
    private EntityResolver entityResolver;

    public DigestReader() {
        this(DigestReader.getDefaultParser(), null);
    }

    public DigestReader(Object[][] defs) {
        this(DigestReader.getDefaultParser(), defs);
    }

    public DigestReader(SAXParser parser) {
        this.parser = parser;
    }

    public DigestReader(SAXParser parser, Object[][] defs) {
        this.parser = parser;
        if (defs != null) {
            this.setRules(defs);
        }
    }

    public void setAliases(Map map2) {
        this.aliasMap = map2;
    }

    public Map getAliases() {
        return this.aliasMap;
    }

    public void setRules(Object[][] defs) {
        int i;
        boolean useDefaultRuleSet = false;
        for (i = 0; i < defs.length; ++i) {
            String path = (String)defs[i][1];
            if (!path.startsWith("//") && path.indexOf("/*") < 0) continue;
            useDefaultRuleSet = true;
            break;
        }
        if (useDefaultRuleSet) {
            this.setRuleSet(new DefaultRuleSet());
        } else {
            this.setRuleSet(new SimpleRuleSet());
        }
        for (i = 0; i < defs.length; ++i) {
            Object[] tpl = defs[i];
            Object type = tpl[0];
            String path = (String)tpl[1];
            DigestAction action = null;
            action = type instanceof DigestAction ? (DigestAction)type : (DigestAction)this.aliasMap.get(type);
            if (action == null) continue;
            String key = null;
            if (tpl.length > 2) {
                key = (String)tpl[2];
            }
            this.addRule(action, path, key);
        }
    }

    public Object parse(InputSource input, Object value) throws SAXException, IOException {
        this.setValue(value);
        if (!this.parser.isValidating()) {
            this.entityResolver = new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    return new InputSource(new NullInputStream());
                }
            };
        }
        this.parser.parse(input, (DefaultHandler)this);
        return this.getValue();
    }

    public Object parse(InputStream input, Object value) throws SAXException, IOException {
        return this.parse(new InputSource(input), value);
    }

    public Object parse(InputSource input) throws SAXException, IOException {
        return this.parse(input, new HashMap());
    }

    public Object parse(InputStream input) throws SAXException, IOException {
        return this.parse(new InputSource(input));
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.entityResolver != null) {
            try {
                return this.entityResolver.resolveEntity(publicId, systemId);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    static SAXParser getDefaultParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            return factory.newSAXParser();
        }
        catch (SAXException e1) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return null;
    }

    static class NullInputStream
    extends InputStream {
        NullInputStream() {
        }

        public int read() throws IOException {
            return -1;
        }

        public int read(byte[] buf, int offse, int size2) throws IOException {
            return -1;
        }
    }
}

