/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.ta.ApplicationState;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLAppExecutionDAO
extends AbstractDAO
implements AppExecutionDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String APP_NAME = "APP_NAME";
    public static final String TOOL_AGENT = "TOOL_AGENT";
    public static final String EXEC_ID = "EXEC_ID";
    public static final String START_DATE = "START_DATE";
    public static final String STARTER_ID = "STARTER_ID";
    public static final String END_DATE = "END_DATE";
    public static final String APP_STATE = "APP_STATE";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from APPEXEC where APP_NAME = ? and TOOL_AGENT = ? and EXEC_ID = ?";
    private static final String SQL_SELECT_BY_EXEC_ID = "select * from APPEXEC where EXEC_ID = ? ";
    private static final String SQL_SELECT_BY_STARTER_ID = "select * from APPEXEC where STARTER_ID = ? ";
    private static final String SQL_INSERT = "insert into APPEXEC (APP_NAME, TOOL_AGENT, EXEC_ID, START_DATE, STARTER_ID, END_DATE, APP_STATE) values (?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_UPDATE_STATE = "update APPEXEC set APP_STATE = ? where APP_NAME = ? and TOOL_AGENT = ? and EXEC_ID = ? and APP_STATE = ?";
    private static final String SQL_UPDATE_STATE_END_DATE = "update APPEXEC set APP_STATE = ?, END_DATE = ? where APP_NAME = ? and TOOL_AGENT = ? and EXEC_ID = ? and APP_STATE = ?";

    MySQLAppExecutionDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppExecutionBean findByPrimaryKey(String appName, String toolAgent, int execID) throws SQLException, DAOException {
        AppExecutionBean bean = null;
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, appName);
            st.setString(2, toolAgent);
            st.setInt(3, execID);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            if (rs.next()) {
                bean = this.createBean(rs);
            }
        }
        finally {
            st.close();
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByExecID(int execID) throws SQLException, DAOException {
        ArrayList<AppExecutionBean> list = new ArrayList<AppExecutionBean>();
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_EXEC_ID);
        try {
            st.setInt(1, execID);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                AppExecutionBean bean = this.createBean(rs);
                list.add(bean);
            }
        }
        finally {
            st.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByStarterID(String starterID) throws SQLException, DAOException {
        ArrayList<AppExecutionBean> list = new ArrayList<AppExecutionBean>();
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_STARTER_ID);
        try {
            st.setString(1, starterID);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                AppExecutionBean bean = this.createBean(rs);
                list.add(bean);
            }
        }
        finally {
            st.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(AppExecutionBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getAppName());
            st.setString(2, bean.getToolAgent());
            st.setInt(3, bean.getExecId());
            st.setTimestamp(4, bean.getStartDate());
            st.setString(5, bean.getStarterId());
            st.setTimestamp(6, bean.getEndDate());
            st.setInt(7, bean.getAppState().toInt());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0005");
                errMsg = errMsg + "APPNAME=" + bean.getAppName() + ", " + "TOOL_AGENT=" + bean.getToolAgent() + ", " + "EXEC_ID=" + bean.getExecId() + ", " + "START_DATE=" + bean.getStartDate() + ", " + "STARTER_ID=" + bean.getStarterId() + ", " + "END_DATE=" + bean.getEndDate() + ", " + "APP_STATE=" + bean.getAppState();
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(String appName, String toolAgent, int execID, ApplicationState oldState, ApplicationState newState) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_STATE);
        try {
            st.setInt(1, newState.toInt());
            st.setString(2, appName);
            st.setString(3, toolAgent);
            st.setInt(4, execID);
            st.setInt(5, oldState.toInt());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0006");
                errMsg = errMsg + "APPNAME=" + appName + ", " + "TOOL_AGENT=" + toolAgent + ", " + "EXEC_ID=" + execID + ", " + "OLD_STATE=" + oldState + ", " + "NEW_STATE=" + newState;
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(String appName, String toolAgent, int execID, ApplicationState oldState, ApplicationState newState, Timestamp newDate) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_STATE_END_DATE);
        try {
            st.setInt(1, newState.toInt());
            st.setTimestamp(2, newDate);
            st.setString(3, appName);
            st.setString(4, toolAgent);
            st.setInt(5, execID);
            st.setInt(6, oldState.toInt());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0006");
                errMsg = errMsg + "APPNAME=" + appName + ", " + "TOOL_AGENT=" + toolAgent + ", " + "EXEC_ID=" + execID + ", " + "OLD_STATE=" + oldState + ", " + "NEW_STATE=" + newState + ", " + "NEW_END_DATE=" + newDate;
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private AppExecutionBean createBean(ResultSet rs) throws SQLException {
        AppExecutionBean bean = new AppExecutionBean();
        bean.setAppName(rs.getString(APP_NAME));
        bean.setToolAgent(rs.getString(TOOL_AGENT));
        bean.setExecId(rs.getInt(EXEC_ID));
        bean.setStartDate(rs.getTimestamp(START_DATE));
        bean.setStarterId(rs.getString(STARTER_ID));
        bean.setEndDate(rs.getTimestamp(END_DATE));
        bean.setAppState(ApplicationState.toApplicationState(rs.getInt(APP_STATE)));
        return bean;
    }
}

