/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;
import org.wfmc.x2002.xpdl10.ActivityDocument;
import org.wfmc.x2002.xpdl10.ActualParametersDocument;
import org.wfmc.x2002.xpdl10.BlockActivityDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributeDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributesDocument;
import org.wfmc.x2002.xpdl10.ImplementationDocument;
import org.wfmc.x2002.xpdl10.SubFlowDocument;
import org.wfmc.x2002.xpdl10.ToolDocument;

public class ActivityDefinitionImpl
implements ActivityDefinition {
    private static final long serialVersionUID = 20050000000000001L;
    private static final String UNINITIALIZED_ID = "--UNINITIALIZED--";
    private String id;
    private String name;
    private String description;
    private int limit;
    private int logicalX;
    private int logicalY;
    private String blockID;
    private String affiliateBID;
    private String parentBID;
    private String applicationID;
    private String subprocessID;
    private String performerID;
    private int sync;
    private List applicationParameters = new ArrayList();
    private List subprocessParameters = new ArrayList();
    private String type;
    private String engineName;

    public ActivityDefinitionImpl(ActivityDocument.Activity act) {
        String id = act.getId();
        if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
            this.setID(IDGenerator.generate("AC"));
        } else {
            this.setID(id);
        }
        this.setName(act.getName());
        this.setDescription(act.getDescription());
        try {
            this.setLimit(Integer.parseInt(act.getLimit()));
        }
        catch (Exception ex) {
            this.setLimit(0);
        }
        if (act.isSetBlockActivity()) {
            BlockActivityDocument.BlockActivity ba = act.getBlockActivity();
            this.setBlockID(ba.getBlockId());
        }
        if (act.isSetPerformer()) {
            this.setPerformerID(act.getPerformer());
        }
        if (act.isSetImplementation()) {
            int i;
            int count;
            ActualParametersDocument.ActualParameters aps;
            ImplementationDocument.Implementation imp = act.getImplementation();
            if (imp.isSetSubFlow()) {
                SubFlowDocument.SubFlow sf = imp.getSubFlow();
                this.setSubprocessID(sf.getId());
                this.setExecution(sf.getExecution().intValue());
                if (sf.isSetActualParameters()) {
                    aps = sf.getActualParameters();
                    count = aps.sizeOfActualParameterArray();
                    for (i = 0; i < count; ++i) {
                        String pid = aps.getActualParameterArray(i);
                        this.addSubprocessParameterID(pid);
                    }
                }
            }
            if (imp.sizeOfToolArray() == 1) {
                ToolDocument.Tool tool = imp.getToolArray(0);
                this.setApplicationID(tool.getId());
                if (tool.isSetActualParameters()) {
                    aps = tool.getActualParameters();
                    count = aps.sizeOfActualParameterArray();
                    for (i = 0; i < count; ++i) {
                        String aid = aps.getActualParameterArray(i);
                        this.addApplicationParameterID(aid);
                    }
                }
            }
        }
        if (act.isSetExtendedAttributes()) {
            ExtendedAttributesDocument.ExtendedAttributes eas = act.getExtendedAttributes();
            int count = eas.sizeOfExtendedAttributeArray();
            for (int i = 0; i < count; ++i) {
                ExtendedAttributeDocument.ExtendedAttribute ea = eas.getExtendedAttributeArray(i);
                String n = ea.getName();
                String v = ea.getValue();
                if (n.equals("LOGICAL_X")) {
                    this.setLogicalX(Integer.parseInt(v));
                    continue;
                }
                if (n.equals("LOGICAL_Y")) {
                    this.setLogicalY(Integer.parseInt(v));
                    continue;
                }
                if (n.equals("AFFILIATE_BID")) {
                    this.setAffiliateBID(v);
                    continue;
                }
                if (n.equals("PARENT_BID")) {
                    this.setParentBID(v);
                    continue;
                }
                if (n.equals("ACTIVITY_TYPE")) {
                    this.setType(v);
                    continue;
                }
                if (!n.equals("ENGINE_NANE")) continue;
                this.setEngineName(v);
            }
        }
    }

    public String getBlockID() {
        return this.blockID;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getLogicalX() {
        return this.logicalX;
    }

    public int getLogicalY() {
        return this.logicalY;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public List getApplicationParameters() {
        return this.applicationParameters;
    }

    public String getSubprocessID() {
        return this.subprocessID;
    }

    public List getSubprocessParameters() {
        return this.subprocessParameters;
    }

    public int getExecution() {
        return this.sync;
    }

    public String getAffiliateBID() {
        return this.affiliateBID;
    }

    public String getParentBID() {
        return this.parentBID;
    }

    public String getPerformerID() {
        return this.performerID;
    }

    public String getEngineName() {
        return this.engineName;
    }

    private void setID(String id) {
        this.id = id;
    }

    private void setBlockID(String id) {
        this.blockID = id;
    }

    private void setLimit(int limit) {
        this.limit = limit;
    }

    private void setLogicalX(int x) {
        this.logicalX = x;
    }

    private void setLogicalY(int y) {
        this.logicalY = y;
    }

    private void setType(String type) {
        this.type = type;
    }

    private void setDescription(String desc) {
        this.description = desc;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setApplicationID(String id) {
        this.applicationID = id;
    }

    private void setSubprocessID(String id) {
        this.subprocessID = id;
    }

    private void setExecution(int sync) {
        this.sync = sync;
    }

    private void setAffiliateBID(String id) {
        this.affiliateBID = id;
    }

    private void setParentBID(String id) {
        this.parentBID = id;
    }

    private void setPerformerID(String id) {
        this.performerID = id;
    }

    private void addApplicationParameterID(String id) {
        this.applicationParameters.add(id);
    }

    private void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    private void addSubprocessParameterID(String id) {
        this.subprocessParameters.add(id);
    }
}

