/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.io.IOException;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import jp.co.argo21.nautica.workflow.engine.ActivityBehaviorFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.DefinitionRepositoryImpl;
import jp.co.argo21.nautica.workflow.engine.EndActivityRequestWatcher;
import jp.co.argo21.nautica.workflow.engine.EndProcessRequestWatcher;
import jp.co.argo21.nautica.workflow.engine.InterWorkflowConnectorImpl;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.MessageBroker;
import jp.co.argo21.nautica.workflow.engine.MessageTransporter;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.engine.RequesterManager;
import jp.co.argo21.nautica.workflow.engine.ResourceManagerFactory;
import jp.co.argo21.nautica.workflow.engine.SessionManagerFactory;
import jp.co.argo21.nautica.workflow.engine.StartActivityRequestWatcher;
import jp.co.argo21.nautica.workflow.engine.StartProcessRequestWatcher;
import jp.co.argo21.nautica.workflow.engine.SystemChecker;
import jp.co.argo21.nautica.workflow.engine.ToolAgentManager;
import jp.co.argo21.nautica.workflow.engine.WorkItemHandlerImpl;
import jp.co.argo21.nautica.workflow.engine.WorkItemPool;
import jp.co.argo21.nautica.workflow.engine.WorkflowAdminHandlerImpl;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngineHandlerImpl;
import jp.co.argo21.nautica.workflow.jms.MessagingException;
import jp.co.argo21.nautica.workflow.jms.WorkflowMQ;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorPO;
import jp.co.argo21.nautica.workflow.rmi.WorkflowServiceManagerPO;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;
import jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowServiceManager;
import org.apache.log4j.Logger;

public class WorkflowEngine
implements WorkflowServiceManager {
    private static final String LOCKFILE = "nautica.lck";
    private static WorkflowEngine engine;
    private static Logger eLog;
    private DefinitionRepositoryImpl definitionRepository;
    private WorkflowEngineHandlerImpl workflowEngineHandler;
    private WorkflowAdminHandlerImpl workflowAdminHandler;
    private WorkItemHandlerImpl workItemHandler;

    public static void boot(String adminkey) throws Exception {
        SystemChecker.checkBootPath();
        SystemChecker.checkAdmin(adminkey);
        if (!WorkflowEngine.createLockfile()) {
            throw new WorkflowException(StringManager.get("E0001"));
        }
        engine = new WorkflowEngine();
        engine.lock();
    }

    public static void shutdown(String session, String adminkey) throws InvalidSessionException, WorkflowException {
        if (engine == null) {
            eLog.warn((Object)StringManager.get("W0001"));
            return;
        }
        engine.validateSession(session);
        WorkflowEngine.shutdown(adminkey);
    }

    public static WorkflowEngine getInstance() {
        return engine;
    }

    static void shutdown(String adminkey) throws WorkflowException {
        SystemChecker.checkAdmin(adminkey);
        engine.unlock();
    }

    private static boolean createLockfile() {
        String home = System.getProperty("nautica.home");
        String separator = System.getProperty("file.separator");
        String path = home + separator + "temp" + separator + LOCKFILE;
        try {
            File lockFile = new File(path);
            boolean isSuccess = lockFile.createNewFile();
            if (isSuccess) {
                lockFile.deleteOnExit();
            }
            return isSuccess;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static void forceDeleteLockfile() {
        String home = System.getProperty("nautica.home");
        String separator = System.getProperty("file.separator");
        String path = home + separator + "temp" + separator + LOCKFILE;
        File lockFile = new File(path);
        if (lockFile.exists()) {
            lockFile.delete();
        }
    }

    private WorkflowEngine() {
    }

    public String connect(String user, String pass) throws ConnectionFailedException {
        String argInfo = "(WfMC API = connect,user = [" + user + "]," + "password = [**SECURITY**])";
        try {
            if (user == null || user.trim().equals("")) {
                String E0166 = StringManager.get("E0166");
                throw new ConnectionFailedException(E0166);
            }
            if (pass == null) {
                String E0167 = StringManager.get("E0167");
                throw new ConnectionFailedException(E0167);
            }
            DataAccessManager.begin(false);
            SessionManagerFactory factory = SessionManagerFactory.getInstance();
            SessionManager manager = factory.getSessionManager();
            String session = manager.createSession(user, pass);
            DataAccessManager.commit();
            return session;
        }
        catch (ConnectionFailedException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0172 = StringManager.get("E0172") + argInfo;
            eLog.error((Object)E0172, (Throwable)ex);
            throw new ConnectionFailedException(E0172, ex);
        }
    }

    public void disconnect(String session) throws InvalidSessionException {
        String argInfo = "(WfMC API = disconnect,session = [" + session + "])";
        try {
            DataAccessManager.begin(false);
            SessionManagerFactory factory = SessionManagerFactory.getInstance();
            SessionManager manager = factory.getSessionManager();
            manager.invalidateSession(session);
            DataAccessManager.commit();
        }
        catch (InvalidSessionException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0173 = StringManager.get("E0173") + argInfo;
            eLog.error((Object)E0173, (Throwable)ex);
            throw new InvalidSessionException(E0173, ex);
        }
    }

    public DefinitionRepository getDefinitionRepository(String session) throws InvalidSessionException {
        this.validateSession(session);
        return this.definitionRepository;
    }

    public WorkflowEngineHandler getWorkflowEngineHandler(String session) throws InvalidSessionException {
        this.validateSession(session);
        return this.workflowEngineHandler;
    }

    public WorkflowAdminHandler getWorkflowAdminHandler(String session) throws InvalidSessionException {
        this.validateSession(session);
        return this.workflowAdminHandler;
    }

    public WorkItemHandler getWorkItemHandler(String session) throws InvalidSessionException {
        this.validateSession(session);
        return this.workItemHandler;
    }

    public void generateQueue(String session, String queueName, WorkflowMessageAdapter adapter) throws InvalidSessionException, WorkflowException {
        this.validateSession(session);
        if (queueName == null || queueName.trim().equals("")) {
            String E0168 = StringManager.get("E0168");
            throw new WorkflowException(E0168);
        }
        if (adapter == null) {
            String E0169 = StringManager.get("E0169");
            throw new WorkflowException(E0169);
        }
        MessageBroker broker = MessageBroker.getInstance();
        broker.generateQueue(queueName, adapter);
    }

    public MessageTransporter getMessageTransporter(String session, String queueName) throws InvalidSessionException, MessagingException {
        this.validateSession(session);
        if (queueName == null || queueName.trim().equals("")) {
            String E0168 = StringManager.get("E0168");
            throw new MessagingException(E0168);
        }
        MessageBroker broker = MessageBroker.getInstance();
        WorkflowMQ mq = broker.getWorkflowMQ(queueName);
        if (mq == null) {
            String E0171 = StringManager.get("E0171") + "(Queue = " + queueName + ")";
            throw new MessagingException(E0171);
        }
        return new MessageTransporter(queueName);
    }

    DefinitionRepositoryImpl getDefinitionRepository() {
        return this.definitionRepository;
    }

    WorkflowEngineHandlerImpl getWorkflowEngineHandler() {
        return this.workflowEngineHandler;
    }

    WorkflowAdminHandlerImpl getWorkflowAdminHandler() {
        return this.workflowAdminHandler;
    }

    WorkItemHandlerImpl getWorkItemHandler() {
        return this.workItemHandler;
    }

    MessageTransporter getMessageTransporter(String queueName) throws MessagingException {
        MessageBroker broker = MessageBroker.getInstance();
        WorkflowMQ mq = broker.getWorkflowMQ(queueName);
        if (mq == null) {
            String E0171 = StringManager.get("E0171") + "(Queue = " + queueName + ")";
            throw new MessagingException(E0171);
        }
        return new MessageTransporter(queueName);
    }

    private synchronized void lock() throws InterruptedException, Exception {
        try {
            this.init();
            eLog.info((Object)StringManager.get("I0002"));
        }
        catch (Exception ex) {
            WorkflowEngine.forceDeleteLockfile();
            String E0002 = StringManager.get("E0002");
            eLog.error((Object)E0002, (Throwable)ex);
            throw ex;
        }
        this.wait();
        System.exit(0);
    }

    private synchronized void unlock() {
        this.notifyAll();
    }

    private void init() throws Exception {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        LogManager.create();
        eLog = LogManager.getEngineLogger();
        eLog.info((Object)StringManager.get("I0001"));
        MessageBroker.create();
        eLog.info((Object)StringManager.get("I0004"));
        ResourceManagerFactory.create();
        eLog.info((Object)StringManager.get("I0005"));
        SessionManagerFactory.create();
        eLog.info((Object)StringManager.get("I0006"));
        DataAccessManager.create();
        eLog.info((Object)StringManager.get("I0025"));
        RequesterManager.create();
        eLog.info((Object)StringManager.get("I0026"));
        ToolAgentManager.create();
        eLog.info((Object)StringManager.get("I0027"));
        ProcessManagerFactory.create();
        eLog.info((Object)StringManager.get("I0028"));
        ActivityBehaviorFactory.create();
        eLog.info((Object)StringManager.get("I0029"));
        WorkItemPool.create();
        eLog.info((Object)StringManager.get("I0030"));
        String interWorkflow = System.getProperty("nautica.workflow.interworkflow");
        if (interWorkflow != null && interWorkflow.equals("enable")) {
            InterWorkflowConnectorImpl.create();
            eLog.info((Object)StringManager.get("I0007"));
        }
        this.bindLocalService();
        eLog.info((Object)StringManager.get("I0008"));
        this.bindRemoteService();
        eLog.info((Object)StringManager.get("I0009"));
        MessageBroker broker = MessageBroker.getInstance();
        broker.generateQueue("START_PROCESS_REQUEST", new StartProcessRequestWatcher());
        eLog.info((Object)StringManager.get("I0041"));
        broker.generateQueue("START_ACTIVITY_REQUEST", new StartActivityRequestWatcher());
        eLog.info((Object)StringManager.get("I0042"));
        broker.generateQueue("END_ACTIVITY_REQUEST", new EndActivityRequestWatcher());
        eLog.info((Object)StringManager.get("I0043"));
        broker.generateQueue("END_PROCESS_REQUEST", new EndProcessRequestWatcher());
        eLog.info((Object)StringManager.get("I0044"));
    }

    private void bindLocalService() throws Exception {
        this.definitionRepository = new DefinitionRepositoryImpl();
        eLog.info((Object)StringManager.get("I0010"));
        this.workflowEngineHandler = new WorkflowEngineHandlerImpl();
        eLog.info((Object)StringManager.get("I0011"));
        this.workflowAdminHandler = new WorkflowAdminHandlerImpl();
        eLog.info((Object)StringManager.get("I0012"));
        this.workItemHandler = new WorkItemHandlerImpl();
        eLog.info((Object)StringManager.get("I0013"));
    }

    private void bindRemoteService() throws Exception {
        String scope = System.getProperty("nautica.workflow.scope");
        if (scope == null) {
            scope = "";
        }
        scope = scope.trim();
        eLog.info((Object)("Workflow engine scope name: [" + scope + "]"));
        InitialContext context = new InitialContext();
        try {
            context.createSubcontext(scope);
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        if (!scope.equals("")) {
            scope = scope + "/";
        }
        WorkflowServiceManagerPO wsmPO = new WorkflowServiceManagerPO(this, this.definitionRepository, this.workflowEngineHandler, this.workflowAdminHandler, this.workItemHandler);
        context.rebind(scope + "WorkflowServiceManager", (Object)wsmPO);
        eLog.info((Object)(StringManager.get("I0014") + "(" + scope + "WorkflowServiceManager" + ")"));
        String interWorkflow = System.getProperty("nautica.workflow.interworkflow");
        if (interWorkflow != null && interWorkflow.equals("enable")) {
            InterWorkflowConnector c = InterWorkflowConnectorImpl.getInstance();
            InterWorkflowConnectorPO iwcPO = new InterWorkflowConnectorPO(c);
            context.rebind(scope + "InterWorkflowConnector", (Object)iwcPO);
            eLog.info((Object)(StringManager.get("I0015") + "(" + scope + "InterWorkflowConnector" + ")"));
        }
    }

    private void shutdown() throws Exception {
        MessageBroker broker = MessageBroker.getInstance();
        broker.shutdown();
        this.unbindRemoteService();
        eLog.info((Object)StringManager.get("I0016"));
        this.unbindLocalService();
        eLog.info((Object)StringManager.get("I0017"));
    }

    private void unbindLocalService() throws Exception {
        this.definitionRepository.unbind();
        this.definitionRepository = null;
        eLog.info((Object)StringManager.get("I0018"));
        this.workflowEngineHandler = null;
        eLog.info((Object)StringManager.get("I0019"));
        this.workflowAdminHandler = null;
        eLog.info((Object)StringManager.get("I0020"));
        this.workItemHandler = null;
        eLog.info((Object)StringManager.get("I0021"));
    }

    private void unbindRemoteService() throws Exception {
        String scope = System.getProperty("nautica.workflow.scope");
        if (scope == null) {
            scope = "";
        }
        scope = scope.trim();
        InitialContext context = new InitialContext();
        if (!scope.equals("")) {
            scope = scope + "/";
        }
        context.unbind(scope + "WorkflowServiceManager");
        eLog.info((Object)StringManager.get("I0022"));
        context.unbind(scope + "InterWorkflowConnector");
        eLog.info((Object)StringManager.get("I0023"));
    }

    private void validateSession(String session) throws InvalidSessionException {
        if (session == null || session.trim().equals("")) {
            String E0170 = StringManager.get("E0170");
            throw new InvalidSessionException(E0170);
        }
        SessionManagerFactory factory = SessionManagerFactory.getInstance();
        SessionManager manager = factory.getSessionManager();
        manager.validateSession(session);
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                engine.shutdown();
                eLog.info((Object)StringManager.get("I0003"));
            }
            catch (Exception ex) {
                String E0002 = StringManager.get("E0003");
                eLog.error((Object)E0002, (Throwable)ex);
            }
            finally {
                WorkflowEngine.forceDeleteLockfile();
            }
        }
    }
}

