/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.security.simple;

import javax.naming.InitialContext;
import jp.co.argo21.nautica.workflow.dataaccess.UserBean;
import jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.simple.UserManager;
import jp.co.argo21.nautica.workflow.security.simple.UserManagerPO;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;
import org.apache.log4j.Logger;

public class SimpleUserManager
implements UserManager {
    private static final String WORKFLOW_USER_MANAGER = "WorkflowUserManager";
    private static Logger sLog = LogManager.getSercurityLogger();

    public SimpleUserManager() throws Exception {
        try {
            UserManagerPO umPO = new UserManagerPO(this);
            InitialContext context = new InitialContext();
            context.rebind(WORKFLOW_USER_MANAGER, (Object)umPO);
            sLog.info((Object)StringManager.get("I1005"));
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E1008");
            sLog.error((Object)errMsg, (Throwable)ex);
            throw ex;
        }
    }

    public User getUser(String uid) throws WorkflowSecurityException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            UserManagerDAO usermanagerDAO = daoFactory.getUserManagerDAO();
            UserBean user = usermanagerDAO.findByUserID(uid);
            return user;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1010") + "(UserID = " + uid + ")";
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }
}

