/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.List;
import javax.sql.DataSource;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.MessageTransporter;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.jms.MessagingException;
import jp.co.argo21.nautica.workflow.ta.AppExecutionInfo;
import jp.co.argo21.nautica.workflow.ta.ApplicationState;
import jp.co.argo21.nautica.workflow.ta.ToolAgentHandleCreator;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationBusyException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotDefinedException;
import jp.co.argo21.nautica.workflow.wfmc.ApplicationNotStartedException;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidToolAgentException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgent;
import org.apache.log4j.Logger;

public abstract class AbstractToolAgent
implements ToolAgent {
    public static final String TOOLAGENT_PATH;
    protected Logger log = Logger.getLogger(this.getClass());
    protected MessageTransporter tp = null;
    protected int retryCount = 1;
    protected String userId = null;
    protected String passwd = null;
    protected String session = null;

    protected abstract String getToolAgentClassName();

    protected abstract String getQueueName();

    protected abstract AppExecutionInfo getExecInfo(String var1, String var2, int var3, Attribute[] var4);

    protected abstract void checkApplicationDefined(String var1) throws ApplicationNotDefinedException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int invokeApplication(String appName, String wid, Attribute[] attrList) throws ApplicationNotStartedException, ApplicationNotDefinedException, ApplicationBusyException {
        String msg = StringManager.get("I2001") + "(ApplicationName=" + appName + ", " + "WorkItemID=" + wid + ", " + "Attributes=" + attrList + ")";
        this.log.info((Object)msg);
        int handler = 0;
        this.checkApplicationDefined(appName);
        Connection sqlConn = null;
        try {
            try {
                handler = ToolAgentHandleCreator.generate();
                DataSource ds = DataAccessManager.getDataSource();
                sqlConn = ds.getConnection();
                sqlConn.setAutoCommit(false);
                WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
                AppExecutionDAO appExecutionDao = factory.getAppExecutionDAO(sqlConn);
                AppExecutionBean bean = new AppExecutionBean();
                bean.setAppName(appName);
                bean.setToolAgent(this.getToolAgentClassName());
                bean.setExecId(handler);
                bean.setStartDate(new Timestamp(System.currentTimeMillis()));
                bean.setStarterId(wid);
                bean.setAppState(ApplicationState.NOT_STARTED);
                appExecutionDao.insert(bean);
                AppExecutionInfo info = this.getExecInfo(appName, wid, handler, attrList);
                info.setRetryCount(this.retryCount);
                this.sendMessage(info);
                sqlConn.commit();
            }
            catch (Exception ex) {
                try {
                    sqlConn.rollback();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                String errMsg = StringManager.get("E2001") + "(ApplicationName=" + appName + ", " + "WorkItemID=" + wid + ", " + "Attributes=" + attrList + ")";
                this.log.error((Object)errMsg, (Throwable)ex);
                throw new ApplicationNotStartedException(errMsg, ex);
            }
            Object var13_15 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                if (sqlConn == null) throw throwable;
                if (sqlConn.isClosed()) throw throwable;
                sqlConn.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        if (sqlConn != null && !sqlConn.isClosed()) {
            sqlConn.close();
        }
        this.log.info((Object)StringManager.get("I2002"));
        return handler;
    }

    protected void retryApplication(AppExecutionInfo info) throws ApplicationNotStartedException {
        try {
            String msg = StringManager.get("I2013") + "(ApplicationExecutionInfomation=" + info + ")";
            this.log.info((Object)msg);
            this.sendMessage(info);
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E2001");
            throw new ApplicationNotStartedException(errMsg, ex);
        }
    }

    protected void setRetryCount(int count) {
        this.retryCount = count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int requestAppStatus(int toolAgentHandle, String wid) throws ApplicationBusyException, InvalidToolAgentException, InvalidWorkItemException {
        String msg = StringManager.get("I2005") + "(ToolAgentHandler=" + toolAgentHandle + ", " + "WorkItemID=" + wid + ")";
        this.log.info((Object)msg);
        int state = ApplicationState.NOT_STARTED.toInt();
        Connection conn = null;
        try {
            try {
                DataSource ds = DataAccessManager.getDataSource();
                conn = ds.getConnection();
                WorkflowDAOFactory factory = DataAccessManager.getDAOFactory();
                AppExecutionDAO dao = factory.getAppExecutionDAO(conn);
                List list = dao.findByExecID(toolAgentHandle);
                if (list.size() != 1) {
                    String errMsg = StringManager.get("E2003") + "(ToolAgentHandler=" + toolAgentHandle + ", " + "WorkItemID=" + wid + ")";
                    throw new InvalidToolAgentException(errMsg);
                }
                AppExecutionBean bean = (AppExecutionBean)list.get(0);
                state = bean.getAppState().toInt();
            }
            catch (InvalidToolAgentException ex) {
                this.log.error((Object)StringManager.get("E2003"), (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                String errMsg = StringManager.get("E2003");
                this.log.error((Object)errMsg, (Throwable)ex);
                throw new InvalidToolAgentException(errMsg, ex);
            }
            Object var12_15 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            try {
                if (conn == null) throw throwable;
                if (conn.isClosed()) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
        this.log.info((Object)(StringManager.get("I2006") + "(ExecutionState=" + state + ")"));
        return state;
    }

    protected String connect() throws ConnectionFailedException {
        if (this.session != null) {
            this.disconnect(this.session);
        }
        WorkflowEngine engine = WorkflowEngine.getInstance();
        this.session = engine.connect(this.userId, this.passwd);
        return this.session;
    }

    protected void disconnect(String session) {
        WorkflowEngine engine = WorkflowEngine.getInstance();
        try {
            engine.disconnect(this.session);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session = null;
    }

    private MessageTransporter getMessageTransporter() throws InvalidSessionException, MessagingException {
        if (this.tp == null) {
            WorkflowEngine engine = WorkflowEngine.getInstance();
            String session = null;
            try {
                session = this.connect();
                this.tp = engine.getMessageTransporter(session, this.getQueueName());
            }
            catch (ConnectionFailedException ex) {
                String errMsg = StringManager.get("E8001");
                throw new InvalidSessionException(errMsg, ex);
            }
            finally {
                this.disconnect(session);
            }
        }
        return this.tp;
    }

    private void sendMessage(AppExecutionInfo info) throws InvalidSessionException, MessagingException {
        info.setRetryCount(info.getRetryCount() - 1);
        this.getMessageTransporter().sendMessage(info);
    }

    static {
        String home = System.getProperty("nautica.home");
        String separator = System.getProperty("file.separator");
        TOOLAGENT_PATH = home + separator + "toolagent";
    }
}

