/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.boundedvm;

import java.util.List;
import javax.jms.JMSException;
import org.activemq.broker.BrokerClient;
import org.activemq.filter.Filter;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.util.MemoryBoundedQueue;
import org.activemq.service.boundedvm.TransientSubscription;
import org.activemq.util.JMSExceptionHelper;

public class TransientQueueSubscription
extends TransientSubscription {
    private MemoryBoundedQueue dispatchedQueue;
    private MemoryBoundedQueue ackedQueue;

    public TransientQueueSubscription(BrokerClient client, MemoryBoundedQueue dispatchedQueue, MemoryBoundedQueue ackQueue, Filter filter, ConsumerInfo info) {
        super(filter, info, client);
        this.dispatchedQueue = dispatchedQueue;
        this.ackedQueue = ackQueue;
    }

    public boolean isTarget(ActiveMQMessage message) throws JMSException {
        boolean result = false;
        if (!(message == null || this.client.isClusteredConnection() && message.isEntryCluster(this.clusterName) && !message.isEntryBroker(this.brokerName))) {
            result = this.filter.matches(message) && (message.getJMSDeliveryMode() == 1 || this.consumerInfo.getDestination().isTemporary());
        }
        return result;
    }

    public boolean canAcceptMessages() {
        return this.dispatchedQueue.size() <= this.consumerInfo.getPrefetchNumber();
    }

    public void doDispatch(ActiveMQMessage message) throws JMSException {
        this.addDispatchedMessage(message);
        message = message.shallowCopy();
        message.setConsumerNos(new int[]{this.consumerInfo.getConsumerNo()});
        this.client.dispatch(message);
    }

    private void addDispatchedMessage(ActiveMQMessage message) throws JMSException {
        try {
            this.dispatchedQueue.enqueueFirst(message);
        }
        catch (InterruptedException e) {
            throw JMSExceptionHelper.newJMSException("Interrupted.", e);
        }
    }

    public ActiveMQMessage acknowledgeMessage(String id) {
        ActiveMQMessage msg = (ActiveMQMessage)this.dispatchedQueue.remove(id);
        return msg;
    }

    public List getUndeliveredMessages() {
        return this.dispatchedQueue.getContents();
    }

    public void close() {
        super.close();
        this.dispatchedQueue.close();
        this.ackedQueue.close();
    }

    public boolean hasAckedMessage() {
        return !this.ackedQueue.isEmpty();
    }

    public void addAckedMessage(ActiveMQMessage message) {
        this.ackedQueue.enqueueFirstNoBlock(message);
    }

    public List listAckedMessages() {
        return this.ackedQueue.getContents();
    }

    public void removeAllAckedMessages() {
        this.ackedQueue.clear();
    }

    public boolean isBrowser() {
        return this.consumerInfo.isBrowser();
    }
}

