/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import javax.jms.JMSException;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.MessageAck;
import org.activemq.service.MessageContainerAdmin;
import org.activemq.service.MessageIdentity;
import org.activemq.service.QueueList;
import org.activemq.service.QueueListEntry;
import org.activemq.service.QueueMessageContainer;
import org.activemq.service.TransactionManager;
import org.activemq.service.TransactionTask;
import org.activemq.service.impl.DefaultQueueList;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.RecoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableQueueMessageContainer
implements QueueMessageContainer,
MessageContainerAdmin {
    private static final Log log = LogFactory.getLog((Class)DurableQueueMessageContainer.class);
    private MessageStore messageStore;
    private String destinationName;
    private boolean deadLetterQueue;
    private QueueList messagesToBeDelivered;
    private QueueList deliveredMessages;
    private PersistenceAdapter persistenceAdapter;

    public DurableQueueMessageContainer(PersistenceAdapter persistenceAdapter, MessageStore messageStore, String destinationName) {
        this(persistenceAdapter, messageStore, destinationName, new DefaultQueueList(), new DefaultQueueList());
    }

    public DurableQueueMessageContainer(PersistenceAdapter persistenceAdapter, MessageStore messageStore, String destinationName, QueueList messagesToBeDelivered, QueueList deliveredMessages) {
        this.persistenceAdapter = persistenceAdapter;
        this.messageStore = messageStore;
        this.destinationName = destinationName;
        this.messagesToBeDelivered = messagesToBeDelivered;
        this.deliveredMessages = deliveredMessages;
        this.deadLetterQueue = destinationName.startsWith("org.activemq.deadletter.");
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void addMessage(ActiveMQMessage message) throws JMSException {
        this.messageStore.addMessage(message);
        final MessageIdentity answer = message.getJMSMessageIdentity();
        TransactionManager.getContexTransaction().addPostCommitTask(new TransactionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws Throwable {
                1 var1_1 = this;
                synchronized (var1_1) {
                    DurableQueueMessageContainer.this.messagesToBeDelivered.add(answer);
                }
            }
        });
    }

    public synchronized void delete(final MessageIdentity messageID, MessageAck ack) throws JMSException {
        this.messageStore.removeMessage(ack);
        TransactionManager.getContexTransaction().addPostCommitTask(new TransactionTask(){

            public void execute() throws Throwable {
                DurableQueueMessageContainer.this.doDelete(messageID);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(MessageIdentity messageID) throws JMSException {
        MessageIdentity storedIdentity = null;
        DurableQueueMessageContainer durableQueueMessageContainer = this;
        synchronized (durableQueueMessageContainer) {
            MessageIdentity identity;
            QueueListEntry entry = this.deliveredMessages.getFirstEntry();
            while (entry != null) {
                identity = (MessageIdentity)entry.getElement();
                if (messageID.equals(identity)) {
                    this.deliveredMessages.remove(entry);
                    storedIdentity = identity;
                    break;
                }
                entry = this.deliveredMessages.getNextEntry(entry);
            }
            if (storedIdentity == null) {
                entry = this.messagesToBeDelivered.getFirstEntry();
                while (entry != null) {
                    identity = (MessageIdentity)entry.getElement();
                    if (messageID.equals(identity)) {
                        this.messagesToBeDelivered.remove(entry);
                        storedIdentity = identity;
                        break;
                    }
                    entry = this.messagesToBeDelivered.getNextEntry(entry);
                }
            }
        }
        if (storedIdentity == null) {
            log.error((Object)("Attempt to acknowledge unknown messageID: " + messageID));
        }
    }

    public ActiveMQMessage getMessage(MessageIdentity messageID) throws JMSException {
        return this.messageStore.getMessage(messageID);
    }

    public boolean containsMessage(MessageIdentity messageIdentity) throws JMSException {
        return this.getMessage(messageIdentity) != null;
    }

    public void registerMessageInterest(MessageIdentity messageIdentity) {
    }

    public void unregisterMessageInterest(MessageIdentity ack) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage poll() throws JMSException {
        ActiveMQMessage message = null;
        MessageIdentity messageIdentity = null;
        DurableQueueMessageContainer durableQueueMessageContainer = this;
        synchronized (durableQueueMessageContainer) {
            messageIdentity = (MessageIdentity)this.messagesToBeDelivered.removeFirst();
            if (messageIdentity != null) {
                this.deliveredMessages.add(messageIdentity);
            }
        }
        if (messageIdentity != null) {
            message = this.messageStore.getMessage(messageIdentity);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveMQMessage peekNext(MessageIdentity messageID) throws JMSException {
        ActiveMQMessage answer = null;
        MessageIdentity identity = null;
        DurableQueueMessageContainer durableQueueMessageContainer = this;
        synchronized (durableQueueMessageContainer) {
            if (messageID == null) {
                identity = (MessageIdentity)this.messagesToBeDelivered.getFirst();
            } else {
                int index = this.messagesToBeDelivered.indexOf(messageID);
                if (index >= 0 && index + 1 < this.messagesToBeDelivered.size()) {
                    identity = (MessageIdentity)this.messagesToBeDelivered.get(index + 1);
                }
            }
        }
        if (identity != null) {
            answer = this.messageStore.getMessage(identity);
        }
        return answer;
    }

    public synchronized void returnMessage(MessageIdentity messageIdentity) throws JMSException {
        boolean result = this.deliveredMessages.remove(messageIdentity);
        this.messagesToBeDelivered.addFirst(messageIdentity);
    }

    public synchronized void reset() throws JMSException {
        int count = 0;
        MessageIdentity messageIdentity = (MessageIdentity)this.deliveredMessages.removeFirst();
        while (messageIdentity != null) {
            this.messagesToBeDelivered.add(count++, messageIdentity);
            messageIdentity = (MessageIdentity)this.deliveredMessages.removeFirst();
        }
    }

    public synchronized void start() throws JMSException {
        DurableQueueMessageContainer container = this;
        this.messageStore.start();
        this.messageStore.recover(new RecoveryListener(){

            public void recoverMessage(MessageIdentity messageIdentity) throws JMSException {
                DurableQueueMessageContainer.this.recoverMessageToBeDelivered(messageIdentity);
            }
        });
    }

    public synchronized void recoverMessageToBeDelivered(MessageIdentity messageIdentity) throws JMSException {
        this.messagesToBeDelivered.add(messageIdentity);
    }

    public void stop() throws JMSException {
        this.messageStore.stop();
    }

    public MessageContainerAdmin getMessageContainerAdmin() {
        return this;
    }

    public void empty() throws JMSException {
        this.messageStore.removeAllMessages();
    }

    public boolean isDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public void setDeadLetterQueue(boolean value) {
        this.deadLetterQueue = value;
    }
}

