/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.cache;

import javax.jms.JMSException;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.MessageAck;
import org.activemq.service.MessageIdentity;
import org.activemq.store.MessageStore;
import org.activemq.store.RecoveryListener;
import org.activemq.store.cache.CacheMessageStoreAware;
import org.activemq.store.cache.CachePersistenceAdapter;
import org.activemq.store.cache.MessageCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheMessageStore
implements MessageStore,
CacheMessageStoreAware {
    private static final Log log = LogFactory.getLog((Class)CacheMessageStore.class);
    private final CachePersistenceAdapter peristenceAdapter;
    private final MessageStore longTermStore;
    private final MessageCache cache;

    public CacheMessageStore(CachePersistenceAdapter adapter, MessageStore longTermStore, MessageCache cache) {
        this.peristenceAdapter = adapter;
        this.longTermStore = longTermStore;
        this.cache = cache;
        this.setCacheMessageStore(this);
    }

    public void addMessage(ActiveMQMessage message) throws JMSException {
        this.longTermStore.addMessage(message);
        this.cache.put(message.getJMSMessageID(), message);
    }

    public void removeMessage(MessageAck ack) throws JMSException {
        this.longTermStore.removeMessage(ack);
        this.cache.remove(ack.getMessageID());
    }

    public ActiveMQMessage getMessage(MessageIdentity identity) throws JMSException {
        ActiveMQMessage answer = null;
        answer = this.cache.get(identity.getMessageID());
        if (answer != null) {
            return answer;
        }
        answer = this.longTermStore.getMessage(identity);
        this.cache.put(identity.getMessageID(), answer);
        return answer;
    }

    public synchronized void recover(RecoveryListener listener) throws JMSException {
        this.longTermStore.recover(listener);
    }

    public void start() throws JMSException {
        this.longTermStore.start();
    }

    public void stop() throws JMSException {
        this.longTermStore.stop();
        this.cache.close();
    }

    public MessageStore getLongTermStore() {
        return this.longTermStore;
    }

    public void setCacheMessageStore(CacheMessageStore store) {
        if (this.longTermStore instanceof CacheMessageStoreAware) {
            ((CacheMessageStoreAware)((Object)this.longTermStore)).setCacheMessageStore(store);
        }
    }

    public void removeAllMessages() throws JMSException {
        this.longTermStore.removeAllMessages();
    }
}

