/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import java.net.InetAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.activemq.ConfigurationException;
import org.activemq.broker.BrokerContainer;
import org.activemq.transport.DiscoveryAgent;
import org.activemq.transport.DiscoveryEvent;
import org.activemq.transport.DiscoveryListener;
import org.activemq.transport.NetworkChannel;
import org.activemq.transport.NetworkConnector;
import org.activemq.util.MapHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryNetworkConnector
extends NetworkConnector
implements DiscoveryListener {
    private static final Log log = LogFactory.getLog((Class)DiscoveryNetworkConnector.class);
    private DiscoveryAgent discoveryAgent;
    private Map channelMap = new HashMap();

    public DiscoveryNetworkConnector(BrokerContainer brokerContainer) {
        super(brokerContainer);
    }

    public void start() throws JMSException {
        DiscoveryAgent discoveryAgent = this.getBrokerContainer().getDiscoveryAgent();
        if (discoveryAgent == null) {
            throw new ConfigurationException("Must be configured with a discoveryAgent property");
        }
        discoveryAgent.addDiscoveryListener(this);
        super.start();
    }

    public void addService(DiscoveryEvent event) {
        try {
            String url;
            Map details = event.getServiceDetails();
            if (!this.getLocalBrokerName().equals(details.get("brokerName")) && (url = MapHelper.getString(details, "connectURL")) != null) {
                this.addChannel(url, details);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Add service failed", (Throwable)e);
        }
    }

    public void removeService(DiscoveryEvent event) {
        try {
            String url;
            Map details = event.getServiceDetails();
            if (!this.getLocalBrokerName().equals(details.get("brokerName")) && (url = MapHelper.getString(details, "connectURL")) != null) {
                this.removeChannel(url, details);
            }
        }
        catch (Exception e) {
            log.warn((Object)"remove service failed", (Throwable)e);
        }
    }

    protected synchronized void addChannel(String url, Map details) {
        NetworkChannel channel = (NetworkChannel)this.channelMap.get(url);
        if (channel == null) {
            try {
                String RELIABLE = "reliable:";
                String urlStr = url.toLowerCase().trim();
                if (urlStr.startsWith("reliable:")) {
                    urlStr = urlStr.substring("reliable:".length());
                }
                String realURL = url;
                URI temp = new URI(urlStr);
                String hostName = temp.getHost();
                if (hostName != null && InetAddress.getByName(hostName).equals(InetAddress.getLocalHost())) {
                    temp = new URI(temp.getScheme(), temp.getUserInfo(), "localhost", temp.getPort(), temp.getPath(), temp.getQuery(), temp.getFragment());
                    realURL = temp.toString();
                }
                channel = this.createNetworkChannel(realURL);
                channel.setUri(realURL);
                log.info((Object)(this.getLocalBrokerName() + ": Adding new NeworkChannel on: " + url + "{resolved=" + realURL + "} with details: " + details));
                channel.start();
                this.channelMap.put(url, channel);
            }
            catch (Exception e) {
                log.error((Object)"Failed to add NetworkChannel", (Throwable)e);
            }
        }
    }

    protected synchronized void removeChannel(String url, Map details) {
        NetworkChannel channel = (NetworkChannel)this.channelMap.remove(url);
        if (channel != null) {
            log.info((Object)(this.getLocalBrokerName() + ": Removing NeworkChannel: " + channel));
            try {
                channel.stop();
            }
            catch (JMSException e) {
                log.info((Object)("Failed to stop channel: " + channel + ". Reason: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected String getLocalBrokerName() {
        return this.getBrokerContainer().getBroker().getBrokerName();
    }
}

