# サンプルアプリ用?ーブル作?? 

# ?ーブル名：キーシーケンス管?
# ?ーブルID?KEYSEQ
# M/T?T
# 備???ユニ?クキー取得用
CREATE TABLE IF NOT EXISTS KEYSEQ (
    NAME            VARCHAR(32)     NOT NULL    PRIMARY KEY 	COMMENT 'キーシーケンス?',
    SEQ             INTEGER(10)     NOT NULL    DEFAULT 0   	COMMENT 'シーケンス、?期値は0'
) ENGINE=InnoDB;


# ?ーブル名：申請種別
# ?ーブルID?APPKIND
# M/T?M
# 備????
CREATE TABLE IF NOT EXISTS APPKIND (
    APPKIND_ID            VARCHAR(128)    NOT NULL    PRIMARY KEY  COMMENT '申請種別コー?',
    APPKIND_NAME          VARCHAR(128)    NOT NULL                 COMMENT '申請種別?',
    ROLE_ID               VARCHAR(64)     NOT NULL                 COMMENT 'ロールID',
    APP_TABLE_NAME        VARCHAR(128)    NOT NULL                 COMMENT '申請テーブル?',
    APPROVE_ACCOUNT       INTEGER(10)     NOT NULL    DEFAULT 0    COMMENT '承認ブロ?ク数',
    CONFIRM_ACCOUNT		  INTEGER(10)	  DEFAULT 0				   COMMENT '同?ブロ?ク数'
) ENGINE=InnoDB;


# ?ーブル名：申請トランザクション
# ?ーブルID?APPTRANSACTION
# M/T?T
# 備????
CREATE TABLE IF NOT EXISTS APPTRANSACTION (
    APP_ID             VARCHAR(128)    NOT NULL     COMMENT '申請書番号',
    APPROVE_ACCOUNT_ID INTEGER(10)     NOT NULL     COMMENT '承認ブロ?クコー?',
    APPKIND_ID         VARCHAR(128)    NOT NULL     COMMENT '申請種別コー?',
    APP_STATUS         VARCHAR(128)    NOT NULL     COMMENT '状?',
    APP_USER_ID        VARCHAR(64)                  COMMENT '申請??/承認??ユーザID',
    APP_ROLE_ID        VARCHAR(64)                  COMMENT '承認??ロールID',
    COMMENT            VARCHAR(128)					COMMENT 'コメン?',
    DATE		       DATETIME                     COMMENT '処?日',
    PRIMARY KEY (APP_ID,APPROVE_ACCOUNT_ID)
) ENGINE=InnoDB;


# ?ーブル名：申?
# ?ーブルID?APPLICATION
# M/T?T
# 備????
CREATE TABLE IF NOT EXISTS APPLICATION (
    APP_ID      VARCHAR(128)    NOT NULL    PRIMARY KEY  	COMMENT '申請書番号',
    APPKIND_ID  VARCHAR(10) 	NOT NULL 					COMMENT '申請種別コー?',
    USER_ID	    VARCHAR(20)     default NULL                COMMENT '申請??ユーザID',
    APP_DATE    DATE            default NULL                COMMENT '申請日'
 ) ENGINE=InnoDB;


# ?ーブル名：時間外申?
# ?ーブルID?OVERTIMEAPP
# M/T?T
# 備????
CREATE TABLE IF NOT EXISTS OVERTIMEAPP (
    APP_ID           VARCHAR(128)    NOT NULL    PRIMARY KEY  	COMMENT '申請書番号',
    WORKDAY          DATE                             		  	COMMENT '勤務日',
    START_TIME       TIME            NOT NULL          		  	COMMENT '開始予定時刻',
    END_TIME         TIME            NOT NULL         		  	COMMENT '終?予定時刻',
    OVERTIME_HOURS   FLOAT(4,1)                               	COMMENT '予定時?',
    COMP_DAY		 INTEGER(1)      default NULL             	COMMENT '代休取得予?',
    COMP_DAY_DATE    DATE      			  	  	              	COMMENT '代休取得日',
    REASON           VARCHAR(255)                     		  	COMMENT '事由',  
    REMARKS	         VARCHAR(255)							  	COMMENT '備??'
) ENGINE=InnoDB;
