/* $Id: AppCancelAction.java,v 1.8 2005/08/26 04:45:11 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.rmi.RemoteException;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.ServiceException;

import jp.co.argo21.nautica.workflow.sample.actionform.UserBean;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.Constants;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * \̃LZsANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class AppCancelAction extends Action {
    
    /**
     * \̃LZsB
     * 
     * @param mapping ANV}bsO
     * @param form    ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return ANVtH[h
     */
    public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
        // NGXg\ԍA\ʁA[U擾
        String appID = (String)request.getSession().getAttribute("appid");
        UserBean user = (UserBean)request.getSession().getAttribute("user");
        String sessionID = user.getSessionID();
        
        try {
            // \gUNVe[uƌʃe[ůYR[h폜
            ApplicationDAO appDao = DAOFactory.getApplicationDAO();
            appDao.remove(appID);
            AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
            appTransDao.remove(appID);
            
            // \ԍtB^[Ɏw肵āAƍڂ擾
            WorkItemHandler wfWorkitemHandler = SingletonServices.getInstance().getWfWorkitemHandler();
            Filter[] filters = new Filter[1];
            Filter filter = new Filter();
            filter.setFilterName(Constants.APPLICATION_NO);
            filter.setFilterString(appID);
            filter.setType(5003);
            filter.setComparison(1);
            filters[0]=filter;
            WorkItem[] workItems = wfWorkitemHandler.getWorkItems(sessionID, filters);
            String wid = workItems[0].getID();
            
            // ƍڂ̃vZXϐu\ԍvɋ󕶎ݒ
            Attribute attr = new Attribute();
            attr.setName(Constants.APPLICATION_NO);
            attr.setValue("");
            attr.setType(1);
            wfWorkitemHandler.assignWorkItemAttribute(sessionID, wid, attr);
            
            // ƍڂ̊
            wfWorkitemHandler.completeWorkItem(sessionID,wid);
           
            return mapping.findForward(Constants.SUCCESS);
        } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (RemoteException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (ServiceException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);
        }    
    }
}