/* $Id: AppMenuAction.java,v 1.9 2005/08/26 04:45:16 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.argo21.nautica.workflow.sample.actionform.UserBean;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.Constants;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.simple.RoleManagerRemote;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * \ꗗ쐬ANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class AppMenuAction extends Action {

    /**
     * OC[U\\Ȑ\ʂ擾B
     * 
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return ANVtH[h
     */
    public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
        // NGXg烆[U擾
        UserBean userbean = (UserBean)request.getSession().getAttribute("user");
        User user = userbean.getUser();
        
        try {
            // [UɊ蓖Ăꂽ[擾
            RoleManagerRemote roleManager = SingletonServices.getInstance().getRoleManager();
            Role[] attachedRoles = roleManager.getAttachedRoles(user);
            
            // 蓖Ăꂽ[ŗp\Ȑ\ʂ擾
            Set appKinds = new HashSet();
            for (int i=0; i < attachedRoles.length; i++) {
                String roleID = attachedRoles[i].getID();
                AppKind[] kinds = DAOFactory.getAppKindDAO().listAppKindByRole(roleID);
                List list = Arrays.asList(kinds);
                appKinds.addAll(list);
            }
            
            if (appKinds.size() == 0) {
                // \\Ȑ\ʂȂ
                List errMsgs = new ArrayList();
                ResourceManager rm = ResourceManager.getInstance();
                errMsgs.add(rm.getValue("error.noapp"));
                request.setAttribute("errorMsg" , errMsgs.toArray());
                return mapping.findForward(Constants.ERROR);            
            }
            
            AppKind[] appKindList = (AppKind[]) appKinds.toArray(new AppKind[appKinds.size()]);
            request.setAttribute("appkindlist", appKindList);
            
            return mapping.findForward(Constants.SUCCESS);
            
        } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (NamingException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (RemoteException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);
        }
    }
}