/* $Id: AppOvertimeInBean.java,v 1.6 2005/08/26 04:45:31 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.actionform;

import java.sql.Timestamp;
import java.util.Calendar;

import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;

/**
 * ԊOJ\̃tH[BeanNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class AppOvertimeInBean extends ApplicationFormInBean {

    /** Ζ */
    private String workDayYear;
    private String workDayMonth;
    private String workDayDay;

    /** Jn\莞 */
    private String startHour;
    private String startMin;

    /** I\莞 */
    private String endHour;
    private String endMin;

    /** \莞 */
    private String overtimeHours;

    /** R */
    private String reason;

    /** x擾\ */
    private String compDay;
    private String compDayYear;
    private String compDayMonth;
    private String compDayDay;

    /** l */
    private String remark;

    
    /**
     * ΖiNjԂB
     * 
     * @return ΖiNj
     */
    public String getWorkDayYear( ) {
        return workDayYear;
    }

    /**
     * ΖiNjݒ肷B
     * 
     * @param workDayYear ΖiNj
     */
    public void setWorkDayYear( String workDayYear ) {
        this.workDayYear = workDayYear;
    }
    
    /**
     * ΖijԂB
     * 
     * @return Ζij
     */
    public String getWorkDayMonth( ) {
        return workDayMonth;
    }

    /**
     * Ζijݒ肷B
     * 
     * @param workDayMonth Ζij
     */
    public void setWorkDayMonth( String workDayMonth ) {
        this.workDayMonth = workDayMonth;
    }
    
    /**
     * ΖijԂB
     * 
     * @return Ζij
     */
    public String getWorkDayDay( ) {
        return workDayDay;
    }

    /**
     * Ζijݒ肷B
     * 
     * @param workDayDay@Ζij
     */
    public void setWorkDayDay( String workDayDay ) {
        this.workDayDay = workDayDay;
    }
    
    /**
     * Jn\莞ijԂB
     * 
     * @return Jn\莞ij
     */
    public String getStartHour( ) {
        return startHour;
    }

    /**
     * Jn\莞ijݒ肷B
     * 
     * @param startHour@Jn\莞ij
     */
    public void setStartHour( String startHour ) {
        this.startHour = startHour;
    }

    /**
     * Jn\莞ijԂB
     * 
     * @return Jn\莞ij
     */
    public String getStartMin( ) {
        return startMin;
    }

    /**
     * Jn\莞ijݒ肷B
     * 
     * @param startMin@Jn\莞ij
     */
    public void setStartMin( String startMin ) {
        this.startMin = startMin;
    }
    
    /**
     * I\莞ijԂB
     * 
     * @return I\莞ij
     */
    public String getEndHour( ) {
        return endHour;
    }

    /**
     * I\莞ijݒ肷B
     * 
     * @param endHour I\莞ij
     */
    public void setEndHour( String endHour ) {
        this.endHour = endHour;
    }

    /**
     * I\莞ijԂB
     * 
     * @return I\莞ij
     */
    public String getEndMin( ) {
        return endMin;
    }

    /**
     * I\莞ijݒ肷B
     * 
     * @param endMin I\莞ij
     */
    public void setEndMin( String endMin ) {
        this.endMin = endMin;
    }

    /**
     * \莞ԂԂB
     * 
     * @return \莞
     */
    public String getOvertimeHours( ) {
        return overtimeHours;
    }

    /**
     * \莞Ԃݒ肷B
     * 
     * @param overtimeHours \莞
     */
    public void setOvertimeHours( String overtimeHours ) {
        this.overtimeHours = overtimeHours;
    }

    /**
     * RԂB
     * 
     * @return R
     */
    public String getReason( ) {
        return reason;
    }

    /**
     * Rݒ肷B
     * 
     * @param reason R
     */
    public void setReason( String reason ) {
        this.reason = reason;
    }
    
    /**
     * x擾\ԂB
     * 
	 * @return x擾\
	 */
	public String getCompDay( ) {
        return compDay;
    }

    /**
     * x擾\ݒ肷B
     * 
	 * @param compDay x擾\
	 */
	public void setCompDay( String compDay ) {
        this.compDay = compDay;
    }
    
    /**
     * x擾\iNjԂB
     * 
     * @return x擾\iNj
     */
    public String getCompDayYear( ) {
        return compDayYear;
    }

    /**
     * x擾\iNjݒ肷B
     * 
     * @param compDayYear x擾\iNj
     */
    public void setCompDayYear( String compDayYear ) {
        this.compDayYear = compDayYear;
    }

    /**
     * x擾\ijԂB
     * 
     * @return x擾\ij
     */
    public String getCompDayMonth( ) {
        return compDayMonth;
    }

    /**
     * x擾\ijݒ肷B
     * 
     * @param compDayMonth x擾\ij
     */
    public void setCompDayMonth( String compDayMonth ) {
        this.compDayMonth = compDayMonth;
    }
    
    /**
     * x擾\ijԂB
     * 
	 * @return x擾\ij
	 */
	public String getCompDayDay( ) {
        return compDayDay;
    }

    /**
     * x擾\ijݒ肷B
     * 
	 * @param compDayDay x擾\ij
	 */
	public void setCompDayDay( String compDayDay ) {
        this.compDayDay = compDayDay;
    }

    /**
     * lԂB
     * 
     * @return l
     */
    public String getRemark( ) {
        return remark;
    }

    /**
     * lݒ肷B
     * 
     * @param remark l
     */
    public void setRemark( String remark ) {
        this.remark = remark;
    }
    
    /**
     * ԊOJ\̃fԂB
     * 
     * @return ԊOJ\f
     */
    public Application getModel( ) {
       OvertimeApp model = new OvertimeApp();
       
       // \ݒ
       model.setDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
       
       // Ζݒ
       Calendar workDay = Calendar.getInstance();
       workDay.set(
               Integer.parseInt(this.getWorkDayYear()),
               Integer.parseInt(this.getWorkDayMonth())-1,
               Integer.parseInt(this.getWorkDayDay())
       );
       Timestamp workDayDate = new Timestamp(workDay.getTime().getTime());
       model.setWorkday(workDayDate);
       
       // Jn\莞ݒ
       model.setStartHour(Integer.parseInt(this.getStartHour()));
       model.setStartMin(Integer.parseInt(this.getStartMin()));
       
       // I\莞ݒ
       model.setEndHour(Integer.parseInt(this.getEndHour()));
       model.setEndMin(Integer.parseInt(this.getEndMin()));
       
       // \莞Ԃݒ
       model.setOvertimeHours(Float.parseFloat(this.getOvertimeHours()));
       
       // Rݒ
       model.setReason(this.getReason());
       
       // x擾\ݒ
       String isCompFalse = "false";
       if (isCompFalse.equals(this.getCompDay())) {
           model.setComp(false);
       } else {
           model.setComp(true);
       }       
       Calendar compDay = Calendar.getInstance();
       compDay.set(
               Integer.parseInt(this.getCompDayYear()),
               Integer.parseInt(this.getCompDayMonth())-1,
               Integer.parseInt(this.getCompDayDay())
       );
       Timestamp date = new Timestamp(compDay.getTime().getTime());
       model.setCompDay(date);
       
       // lݒ
       model.setRemark(this.getRemark());
       
       return model;
    }
}