<%@ page contentType="text/html;charset=Shift_JIS" pageEncoding="Shift_JIS"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-bean" prefix="bean"%> 
<%@ taglib uri="http://jakarta.apache.org/struts/tags-html" prefix="html"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-logic" prefix="logic" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jstl/core_rt" prefix="c" %>

<c:set var="apps" value="${requestScope.applications}"/>
<c:set var="errmsg" value="${requestScope.errorMsg}" />
<html:html> 
	<head>
		<title><bean:message key="notificationlist.title"/></title>
		<link href="/WorkflowSample/css/style.css" rel="stylesheet" type="text/css">
	</head>
	<body>
	<center>
	<table class="big">
	<tr>
		<td colspan="3"><jsp:include page="include/top.jsp" /></td>
	</tr>
	<tr class="titlebar" align="center">
		<td><img src="/WorkflowSample/images/left-bar.jpg" width="300" height="20"></td>
		<td><bean:message key="notificationlist.title"/></td>
		<td><img src="/WorkflowSample/images/right-bar.jpg" width="300" height="20"></td>
	</tr>
	<tr height="60">
		<td colspan="3" align="center"><br>
			<jsp:include page="error.jsp" />
			<logic:empty name="errorMsg" scope="request">
			<table class="data">
			<tr>
			   	<th><bean:message key="label.no"/></th>
    			<th><bean:message key="label.appno"/></th>
    			<th><bean:message key="label.applicantname"/></th>
		    	<th><bean:message key="label.appkind"/></th>
    			<th><bean:message key="label.appdate"/></th>
		    </tr>
		    <c:forEach items="${apps}" var="app" varStatus="status">
			<tr>
				<td class="data" align="right"><c:out value = "${status.count}" /></td>
				<td class="data" align="center"><html:link page="/shownotify.do" paramId="appid" paramName="app" paramProperty="id" ><c:out value = "${app.id}" /></html:link></td>
				<td class="data"><c:out value = "${app.user.name}" /></td>
				<td class="data"><c:out value = "${app.kind.appkindName}" /></td>
				<td class="data" align="center"><fmt:formatDate value="${app.date}" type="date" dateStyle="medium" timeStyle="medium"/></td>
		    </tr>
		    </c:forEach>
		    </table>
			</logic:empty>
		</td>
	</tr>
	<tr>
		<td colspan="3" align="center"><br>
			<html:link forward="mainmenu" ><bean:message key="link.menu"/></html:link><p>
			<jsp:include page="include/bottom.jsp" />
		</td>
	</tr>
	</table>
	</center>
	</body>
</html:html>