/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.php;

import com.sun.script.php.CommonResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

class ConfigTomcat {
    static final String servletTag = "servlet";
    static final String servletSubTag1 = "servlet-name";
    static final String servletSubTag2 = "servlet-class";
    static final String servletSubTag1Value = "JSR223Script";
    static final String servletSubTag2Value = "com.sun.script.http.ScriptServlet";
    static final String initParamTag = "init-param";
    static final String initParamSubTagName1 = "param-name";
    static final String initParamSubTagName2 = "param-value";
    static final String initParamSubTagValue1 = "script-blocks";
    static final String initParamSubTagValue2 = "js,groovy";
    static final String servletMappingTag = "servlet-mapping";
    static final String servletMappingSubTag1 = "servlet-name";
    static final String servletMappingSubTag2 = "url-pattern";
    static final String servletMappingSubTag1Value = "JSR223Script";
    static final String servletMappingSubTag2Value1 = "*.js";
    static final String servletMappingSubTag2Value2 = "*.php";
    static final String servletMappingSubTag2Value3 = "*.groovy";
    static String strDtdVerificationfile = "/tmp/web-app_2_3.dtd";

    ConfigTomcat() {
    }

    void printChildNodesOfElement(Element elem, String strTagName) {
        NodeList nodeList = elem.getElementsByTagName(strTagName);
        int nCount = nodeList.getLength();
        ConfigTomcat.debugPrint("count = " + nCount);
        for (int index = 0; index < nCount; ++index) {
            Node node = nodeList.item(index);
            short nType = node.getNodeType();
            String nodeValue = node.getNodeValue();
            if (nType == 1) {
                ConfigTomcat.debugPrint("Element Node : ");
            }
            ConfigTomcat.debugPrint("    i=" + index + " type = " + nType + " value = " + nodeValue);
        }
    }

    static void debugPrint(String strMsg) {
    }

    Node searchServletNode(Document document, String topElemName, String subElemName, String subElemValue) {
        NodeList servletNodeList = document.getElementsByTagName(topElemName);
        int nCount = servletNodeList.getLength();
        ConfigTomcat.debugPrint("" + nCount);
        for (int index = 0; index < nCount; ++index) {
            Node node = servletNodeList.item(index);
            NodeList servletNodeChildlist = node.getChildNodes();
            for (int jIndex = 0; jIndex < servletNodeChildlist.getLength(); ++jIndex) {
                Node servletChildNode = servletNodeChildlist.item(jIndex);
                short nType = servletChildNode.getNodeType();
                String strNodeName = servletChildNode.getNodeName();
                if (nType != 1 || !strNodeName.equals(subElemName)) continue;
                Element servletNameElem = (Element)servletChildNode;
                String strVal = servletNameElem.getFirstChild().getNodeValue();
                ConfigTomcat.debugPrint("Element Node : " + strVal + "++");
                if (!strVal.equals(subElemValue)) continue;
                return node;
            }
        }
        return null;
    }

    boolean searchServletNode(Document document, String topElemName, String subElemName1, String subElemValue1, String subElemName2, String subElemValue2) {
        NodeList servletNodeList = document.getElementsByTagName(topElemName);
        int nCount = servletNodeList.getLength();
        ConfigTomcat.debugPrint("" + nCount);
        for (int index = 0; index < nCount; ++index) {
            Node node = servletNodeList.item(index);
            NodeList servletNodeChildlist = node.getChildNodes();
            boolean matched1 = false;
            boolean matched2 = false;
            for (int jIndex = 0; jIndex < servletNodeChildlist.getLength(); ++jIndex) {
                String strVal;
                Element servletNameElem;
                Node servletChildNode = servletNodeChildlist.item(jIndex);
                short nType = servletChildNode.getNodeType();
                String strNodeName = servletChildNode.getNodeName();
                if (nType == 1 && strNodeName.equals(subElemName1)) {
                    servletNameElem = (Element)servletChildNode;
                    strVal = servletNameElem.getFirstChild().getNodeValue();
                    ConfigTomcat.debugPrint("Element Node : " + strVal + "++");
                    if (!strVal.equals(subElemValue1)) continue;
                    matched1 = true;
                    continue;
                }
                if (nType == 1 && strNodeName.equals(subElemName2)) {
                    servletNameElem = (Element)servletChildNode;
                    strVal = servletNameElem.getFirstChild().getNodeValue();
                    ConfigTomcat.debugPrint("Element Node : " + strVal + "++");
                    if (strVal.equals(subElemValue2)) {
                        matched2 = true;
                    }
                }
                if (!matched1 || !matched2) continue;
                return true;
            }
        }
        return false;
    }

    Element createNewElement(Document document, String elemName, String subElem1Name, String subElem1Value, String subElem2Name, String subElem2Value, String appendSpaceString) {
        Element root = document.createElement(elemName);
        root.appendChild(document.createTextNode("\n        " + appendSpaceString));
        Element elem = document.createElement(subElem1Name);
        elem.appendChild(document.createTextNode(subElem1Value));
        root.appendChild(elem);
        root.appendChild(document.createTextNode("\n        " + appendSpaceString));
        elem = document.createElement(subElem2Name);
        elem.appendChild(document.createTextNode(subElem2Value));
        root.appendChild(elem);
        root.appendChild(document.createTextNode("\n    " + appendSpaceString));
        ConfigTomcat.debugPrint("creating element = " + root.toString());
        return root;
    }

    Element createNewElement1(Document document, String elemName, String subElem1Name, String subElem1Value, String subElem2Name, String subElem2Value, Element extraElement) {
        Element root = document.createElement(elemName);
        Element elem = document.createElement(subElem1Name);
        elem.appendChild(document.createTextNode(subElem1Value));
        root.appendChild(document.createTextNode("\n        "));
        root.appendChild(elem);
        elem = document.createElement(subElem2Name);
        elem.appendChild(document.createTextNode(subElem2Value));
        root.appendChild(document.createTextNode("\n        "));
        root.appendChild(elem);
        root.appendChild(document.createTextNode("\n        "));
        root.appendChild(extraElement);
        root.appendChild(document.createTextNode("\n    "));
        ConfigTomcat.debugPrint("creating element = " + root.toString());
        return root;
    }

    boolean modifyCurrentElement(Node node, String subElemName, String subElemValue) throws Exception {
        NodeList childNodes = node.getChildNodes();
        ConfigTomcat.debugPrint("Inside modifyCurrentElement");
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node servletChildNode = childNodes.item(index);
            short nType = servletChildNode.getNodeType();
            String strNodeName = servletChildNode.getNodeName();
            if (nType != 1 || !strNodeName.equals(subElemName)) continue;
            Element servletNameElem = (Element)servletChildNode;
            Node nodeToSet = servletNameElem.getFirstChild();
            String strVal = nodeToSet.getNodeValue();
            ConfigTomcat.debugPrint("Element Node : " + strVal + "++");
            if (strVal.equals(subElemValue)) {
                return false;
            }
            nodeToSet.setNodeValue(subElemValue);
            return true;
        }
        throw new Exception("subElement " + subElemName + " Not Found");
    }

    void copyFile(String source, String dest) throws Exception {
        File srcfile = new File(source);
        File destfile = new File(dest);
        FileInputStream in = new FileInputStream(srcfile);
        FileOutputStream out = new FileOutputStream(destfile);
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    boolean backupFile(String filename) throws Exception {
        int nIndex = 0;
        for (nIndex = 0; nIndex < 10000; ++nIndex) {
            String backupFilename = filename + ".bak" + nIndex;
            File file = new File(backupFilename);
            if (file.exists()) continue;
            System.out.println("File " + filename + " is backed up to " + backupFilename);
            this.copyFile(filename, backupFilename);
            return true;
        }
        return false;
    }

    void writeXMLFile_TomcatServerXml(Document document, String filename) throws Exception {
        this.backupFile(filename);
        DocumentType docType = document.getDoctype();
        DOMSource source = new DOMSource(document);
        File fileout = new File(filename);
        StreamResult result = new StreamResult(fileout);
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer xformer = transFact.newTransformer();
        xformer.setOutputProperty("encoding", "ISO-8859-1");
        xformer.transform(source, result);
        fileout = null;
    }

    void writeXMLFile(Document document, String filename) throws Exception {
        this.backupFile(filename);
        DocumentType docType = document.getDoctype();
        DOMSource source = new DOMSource(document);
        File fileout = new File(filename);
        StreamResult result = new StreamResult(fileout);
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer xformer = transFact.newTransformer();
        xformer.setOutputProperty("encoding", "ISO-8859-1");
        Properties props = xformer.getOutputProperties();
        xformer.setOutputProperty("doctype-public", docType.getPublicId());
        xformer.setOutputProperty("doctype-system", docType.getSystemId());
        xformer.transform(source, result);
        fileout = null;
    }

    boolean searchAndModify(Document document, String elemName, String subElem1Name, String subElem1Value, String subElem2Name, String subElem2Value) throws Exception {
        boolean bNodeFound = this.searchServletNode(document, elemName, subElem1Name, subElem1Value, subElem2Name, subElem2Value);
        if (bNodeFound) {
            return false;
        }
        boolean bTestModify = true;
        Node node = this.searchServletNode(document, elemName, subElem2Name, subElem2Value);
        if (node == null) {
            Element elem = this.createNewElement(document, elemName, subElem1Name, subElem1Value, subElem2Name, subElem2Value, "");
            NodeList webAppNode = document.getElementsByTagName("web-app");
            NodeList servletNodeList = document.getElementsByTagName(elemName);
            if (servletNodeList == null) {
                webAppNode.item(0).appendChild(elem);
                webAppNode.item(0).appendChild(document.createTextNode("\n\n\n"));
            } else {
                int nCount = servletNodeList.getLength();
                Node nodeLast = servletNodeList.item(nCount - 1);
                Text spaceNode = document.createTextNode("\n\n    ");
                webAppNode.item(0).insertBefore(spaceNode, nodeLast.getNextSibling());
                webAppNode.item(0).insertBefore(elem, nodeLast.getNextSibling().getNextSibling());
            }
        } else {
            bTestModify = this.modifyCurrentElement(node, subElem1Name, subElem1Value);
        }
        return bTestModify;
    }

    boolean searchAndModify1(Document document, String elemName, String subElem1Name, String subElem1Value, String subElem2Name, String subElem2Value, Element extraElement) throws Exception {
        Node node = this.searchServletNode(document, elemName, subElem1Name, subElem1Value);
        boolean bTestModify = false;
        if (node == null) {
            Element elem = this.createNewElement1(document, elemName, subElem1Name, subElem1Value, subElem2Name, subElem2Value, extraElement);
            bTestModify = true;
            NodeList webAppNode = document.getElementsByTagName("web-app");
            NodeList servletNodeList = document.getElementsByTagName(elemName);
            if (servletNodeList == null) {
                webAppNode.item(0).appendChild(elem);
            } else {
                int nCount = servletNodeList.getLength();
                Node nodeLast = servletNodeList.item(nCount - 1);
                Text spaceNode = document.createTextNode("\n\n    ");
                webAppNode.item(0).insertBefore(spaceNode, nodeLast.getNextSibling());
                webAppNode.item(0).insertBefore(elem, nodeLast.getNextSibling().getNextSibling());
            }
        } else {
            ConfigTomcat.debugPrint("node" + subElem1Name + " " + subElem1Value + " " + subElem2Name + " " + subElem2Value + "Found");
            bTestModify = this.modifyCurrentElement(node, subElem2Name, subElem2Value);
            ConfigTomcat.debugPrint("modifyCurrentElement returned " + bTestModify);
        }
        return bTestModify;
    }

    boolean searchAndModifyAttribute(Document document, String elemName, String attributeName, String appendVal) throws Exception {
        NodeList nodeList = document.getElementsByTagName(elemName);
        int nCount = nodeList.getLength();
        String separator = File.pathSeparator;
        if (nCount <= 0) {
            throw new Exception("No " + elemName + " Found in document");
        }
        String appendValMod = appendVal.replaceAll("\\\\", "/");
        Node node = nodeList.item(0);
        Element curElem = (Element)node;
        String attributeVal = curElem.getAttribute(attributeName);
        String regex = "(^|.*" + separator + ")" + appendValMod + "(" + separator + ".*|$)";
        ConfigTomcat.debugPrint("attributeVal =  " + attributeVal);
        ConfigTomcat.debugPrint("regex = " + regex);
        if (attributeVal.matches(regex)) {
            return false;
        }
        curElem.removeAttribute(attributeName);
        curElem.setAttribute(attributeName, attributeVal + separator + appendValMod);
        return true;
    }

    Element getFirstElement(Object elem, String subElemName) throws Exception {
        NodeList nodeList = null;
        if (elem instanceof Element) {
            nodeList = ((Element)elem).getElementsByTagName(subElemName);
        } else if (elem instanceof Document) {
            nodeList = ((Document)elem).getElementsByTagName(subElemName);
        } else {
            throw new Exception("Illegal Argument to getFirstElement");
        }
        int nCount = nodeList.getLength();
        if (nCount <= 0) {
            throw new Exception("No " + subElemName + " element Found in document");
        }
        Node node = nodeList.item(0);
        if (node.getNodeType() != 1) {
            throw new Exception("No " + subElemName + " element Found in document");
        }
        Element curElem = (Element)node;
        return curElem;
    }

    boolean modifyContextElement(Document document, Element contextElem, String strSampleDir) throws Exception {
        String docbase;
        if (contextElem.hasAttribute("docBase") && (docbase = contextElem.getAttribute("docBase")).compareTo(strSampleDir) == 0) {
            return false;
        }
        contextElem.setAttribute("docBase", strSampleDir);
        return true;
    }

    Element createContextElement(Document document, String strSampleDir) throws Exception {
        Element root = document.createElement("Context");
        root.setAttribute("path", "/jsr223samples");
        root.setAttribute("docBase", strSampleDir);
        root.setAttribute("debug", "0");
        root.setAttribute("reloadable", "true");
        root.setAttribute("crossContext", "true");
        Element elem = document.createElement("Logger");
        elem.setAttribute("className", "org.apache.catalina.logger.FileLogger");
        elem.setAttribute("prefix", "localhost_jsr223");
        elem.setAttribute("suffix", ".txt");
        root.appendChild(document.createTextNode("\n        "));
        root.appendChild(elem);
        root.appendChild(document.createTextNode("\n    "));
        ConfigTomcat.debugPrint("creating element = " + root.toString());
        return root;
    }

    boolean createOrModifyContextElement(Document document, String strSampleDir) throws Exception {
        Element elem = this.getFirstElement(document, "Server");
        Element elemService = this.getFirstElement(elem, "Service");
        Element elemHost = this.getFirstElement(elem, "Host");
        NodeList nodeList = elemHost.getElementsByTagName("Context");
        int nCount = nodeList.getLength();
        Element foundNode = null;
        if (nCount >= 0) {
            for (int index = 0; index < nCount; ++index) {
                String strAttr;
                Element node = (Element)nodeList.item(index);
                if (!node.hasAttribute("path") || (strAttr = node.getAttribute("path")) == null || strAttr.compareTo("/jsr223samples") != 0) continue;
                foundNode = node;
                break;
            }
        }
        if (foundNode == null) {
            Element elemToAdd = this.createContextElement(document, strSampleDir);
            Text spaceNode = document.createTextNode("\n\n    ");
            elemHost.appendChild(spaceNode);
            elemHost.appendChild(elemToAdd);
            elemHost.appendChild(spaceNode);
            ConfigTomcat.debugPrint("document element = " + document.toString());
            return true;
        }
        return this.modifyContextElement(document, foundNode, strSampleDir);
    }

    void configurePhpServlet(String[] args) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            boolean bTestModify4;
            boolean bTestModify3;
            boolean bTestModify2;
            String webXmlFile = args[0];
            DocumentBuilder builder = factory.newDocumentBuilder();
            CommonResolver resolver = new CommonResolver();
            resolver.setDtdFile(strDtdVerificationfile);
            builder.setEntityResolver(resolver);
            File file = new File(webXmlFile);
            FileInputStream fileInpStream = new FileInputStream(file);
            InputSource inpSource = new InputSource(fileInpStream);
            Document document = builder.parse(inpSource);
            file = null;
            DocumentType docType = document.getDoctype();
            Element element = document.getDocumentElement();
            String appendSpaceString = "    ";
            Element paramElem = this.createNewElement(document, initParamTag, initParamSubTagName1, initParamSubTagValue1, initParamSubTagName2, initParamSubTagValue2, appendSpaceString);
            boolean bTestModify1 = this.searchAndModify1(document, servletTag, "servlet-name", "JSR223Script", servletSubTag2, servletSubTag2Value, paramElem);
            if (bTestModify1) {
                System.out.println("Created/Modified servlet element ");
            }
            if (bTestModify2 = this.searchAndModify(document, servletMappingTag, "servlet-name", "JSR223Script", servletMappingSubTag2, servletMappingSubTag2Value1)) {
                System.out.println("Created/Modified servlet-mapping element ");
            }
            if (bTestModify3 = this.searchAndModify(document, servletMappingTag, "servlet-name", "JSR223Script", servletMappingSubTag2, servletMappingSubTag2Value2)) {
                System.out.println("Created/Modified servlet-mapping element ");
            }
            if (bTestModify4 = this.searchAndModify(document, servletMappingTag, "servlet-name", "JSR223Script", servletMappingSubTag2, servletMappingSubTag2Value3)) {
                System.out.println("Created/Modified servlet-mapping element ");
            }
            if (bTestModify1 || bTestModify2 || bTestModify3 || bTestModify4) {
                this.writeXMLFile(document, webXmlFile);
                System.out.println("Modified file " + webXmlFile);
            } else {
                System.out.println("No change in Configuration file " + webXmlFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    void configureWebServer_ServerDotXml(String[] args) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            String webXmlFile = args[1];
            DocumentBuilder builder = factory.newDocumentBuilder();
            CommonResolver resolver = new CommonResolver();
            resolver.setDtdFile(strDtdVerificationfile);
            builder.setEntityResolver(resolver);
            File file = new File(webXmlFile);
            FileInputStream fileInpStream = new FileInputStream(file);
            InputSource inpSource = new InputSource(fileInpStream);
            Document document = builder.parse(inpSource);
            file = null;
            DocumentType docType = document.getDoctype();
            Element element = document.getDocumentElement();
            boolean bVal = this.searchAndModifyAttribute(document, "JAVA", "serverclasspath", args[2]);
            ConfigTomcat.debugPrint("modify val = " + bVal);
            if (bVal) {
                System.out.println("Modifying " + webXmlFile);
                this.writeXMLFile(document, webXmlFile);
            } else {
                System.out.println("No Change in configuration file " + webXmlFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    void configureTomcat_ServerDotXml(String[] args) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            String webXmlFile = args[1];
            DocumentBuilder builder = factory.newDocumentBuilder();
            CommonResolver resolver = new CommonResolver();
            resolver.setDtdFile(strDtdVerificationfile);
            builder.setEntityResolver(resolver);
            File file = new File(webXmlFile);
            FileInputStream fileInpStream = new FileInputStream(file);
            InputSource inpSource = new InputSource(fileInpStream);
            Document document = builder.parse(inpSource);
            file = null;
            DocumentType docType = document.getDoctype();
            Element element = document.getDocumentElement();
            boolean bVal = this.createOrModifyContextElement(document, args[2]);
            ConfigTomcat.debugPrint("modify val = " + bVal);
            if (bVal) {
                System.out.println("Modifying " + webXmlFile);
                this.writeXMLFile_TomcatServerXml(document, webXmlFile);
            } else {
                System.out.println("No Change in configuration file " + webXmlFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        boolean bConfigServerXml = false;
        boolean bConfigTomcatServerXml = false;
        if (args.length < 1) {
            System.err.println("Usage : <Program> [--config_web_server] (<server.xml path> | <path to web.xml> <path to dtd>");
            System.exit(-1);
        }
        int nRequiredArg = 2;
        ConfigTomcat.debugPrint(args[0]);
        if (args[0].compareTo("--config_web_server") == 0) {
            ++nRequiredArg;
            bConfigServerXml = true;
            ConfigTomcat.debugPrint("Configuring server.xml");
        }
        if (args[0].compareTo("--config_tomcat_server_xml") == 0) {
            ++nRequiredArg;
            bConfigTomcatServerXml = true;
            ConfigTomcat.debugPrint("Configuring Tomcat server.xml");
        }
        if (args.length < nRequiredArg) {
            System.err.println("Usage : <Program> [--config_web_server | --config_tomcat_server_xml] (<server.xml path> | <path to web.xml> <path to dtd>");
            System.exit(-1);
        }
        strDtdVerificationfile = args[1];
        ConfigTomcat configTomcat = new ConfigTomcat();
        if (bConfigServerXml) {
            configTomcat.configureWebServer_ServerDotXml(args);
        } else if (bConfigTomcatServerXml) {
            configTomcat.configureTomcat_ServerDotXml(args);
        } else {
            configTomcat.configurePhpServlet(args);
        }
    }
}

