/*
 * Decompiled with CFR 0.152.
 */
package javax.script.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.script.GenericScriptContext;
import javax.script.http.HttpScriptContext;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class GenericHttpScriptContext
extends GenericScriptContext
implements HttpScriptContext {
    protected boolean disableScript;
    protected boolean displayResults;
    protected boolean useSession;
    protected String[] methods;
    protected String[] languages;
    protected String docRoot;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Servlet servlet;
    public static final String[] defaultMethods = new String[]{"GET", "POST"};

    public GenericHttpScriptContext() {
        this.release();
    }

    public boolean disableScript() {
        return this.disableScript;
    }

    public boolean displayResults() {
        return this.displayResults;
    }

    public void forward(String relativePath) throws ServletException, IOException {
        ServletContext context = this.servlet.getServletConfig().getServletContext();
        String uri = this.request.getServletPath();
        String baseURI = uri.substring(0, uri.lastIndexOf(47));
        String path = baseURI + '/' + relativePath;
        context.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public String[] getMethods() {
        return this.methods;
    }

    public String[] getAllowedLanguages() {
        return this.languages;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public Reader getScriptSource() {
        String requestURI = this.request.getRequestURI();
        String resourcePath = requestURI.substring(this.request.getContextPath().length());
        try {
            if (this.docRoot != null) {
                String separator = this.docRoot.endsWith(File.separator) || resourcePath.startsWith(File.separator) ? "" : File.separator;
                String fullPath = this.docRoot + separator + resourcePath;
                return new InputStreamReader(new FileInputStream(fullPath));
            }
            InputStream stream = this.servlet.getServletConfig().getServletContext().getResourceAsStream(resourcePath);
            return new BufferedReader(new InputStreamReader(stream));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void include(String relativePath) throws ServletException, IOException {
        ServletContext context = this.servlet.getServletConfig().getServletContext();
        String uri = this.request.getServletPath();
        String baseURI = uri.substring(0, uri.lastIndexOf(47));
        String path = baseURI + '/' + relativePath;
        context.getRequestDispatcher(path).include((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public void initialize(Servlet servlet, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        StringTokenizer tokenizer;
        this.request = new RequestWrapper(req);
        this.response = res;
        this.servlet = servlet;
        ServletContext context = servlet.getServletConfig().getServletContext();
        this.docRoot = context.getInitParameter("script-directory");
        String disable = context.getInitParameter("script-disable");
        String session = context.getInitParameter("script-use-session");
        String display = context.getInitParameter("script-display-results");
        String methodstring = context.getInitParameter("script-methods");
        String languagesstring = context.getInitParameter("allow-languages");
        if (this.docRoot != null && !new File(this.docRoot).isDirectory()) {
            throw new ServletException("Specified document root ," + this.docRoot + " either does not exist or is not a directory.");
        }
        if (disable != null && disable.equals("true")) {
            this.disableScript = true;
            return;
        }
        if (session != null && session.equals("false")) {
            this.useSession = false;
        }
        if (display != null && display.equals("false")) {
            this.displayResults = false;
        }
        if (methodstring != null) {
            tokenizer = new StringTokenizer(methodstring, ",");
            ArrayList<String> methodList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                methodList.add(tokenizer.nextToken());
            }
            this.methods = methodList.toArray(new String[methodList.size()]);
        }
        if (languagesstring != null && !languagesstring.equals("")) {
            tokenizer = new StringTokenizer(languagesstring, ",");
            ArrayList<String> languagesList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                languagesList.add(tokenizer.nextToken());
            }
            this.languages = languagesList.toArray(new String[languagesList.size()]);
        } else {
            this.languages = null;
        }
    }

    public void release() {
        this.disableScript = false;
        this.displayResults = true;
        this.useSession = true;
        this.methods = defaultMethods;
        this.request = null;
        this.response = null;
        this.servlet = null;
    }

    private void testScopeValue(int scope) {
        if (scope != 0 && scope != 150 && scope != 175) {
            throw new IllegalArgumentException("Invalid scope value.");
        }
        if (scope == 150) {
            HttpSession sess = this.request.getSession();
            if (!this.useSession || sess == null) {
                throw new IllegalStateException("Session state disabled.");
            }
        }
    }

    public void setAttribute(String key, Object value, int scope) {
        this.testScopeValue(scope);
        if (scope == 0) {
            this.request.setAttribute(key, value);
        } else if (scope == 150) {
            this.request.getSession().setAttribute(key, value);
        } else if (scope == 175) {
            System.out.println("setting key = " + key + " value = " + value);
            this.servlet.getServletConfig().getServletContext().setAttribute(key, value);
        }
    }

    public Object getAttribute(String key, int scope) {
        this.testScopeValue(scope);
        if (scope == 0) {
            return this.request.getAttribute(key);
        }
        if (scope == 150) {
            return this.request.getSession().getAttribute(key);
        }
        if (scope == 175) {
            Object obj = this.servlet.getServletConfig().getServletContext().getAttribute(key);
            System.out.println("value = " + obj);
            return obj;
        }
        return null;
    }

    public boolean useSession() {
        return this.useSession;
    }

    public Writer getWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public class RequestWrapper
    extends HttpServletRequestWrapper {
        public RequestWrapper(HttpServletRequest req) {
            super(req);
        }

        public HttpSession getSession() {
            if (GenericHttpScriptContext.this.useSession()) {
                return super.getSession();
            }
            return null;
        }
    }
}

