/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.DataInput;
import java.io.IOException;
import org.activemq.io.impl.AbstractPacketReader;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.Packet;
import org.activemq.message.ProducerInfo;

public class ProducerInfoReader
extends AbstractPacketReader {
    public int getPacketType() {
        return 18;
    }

    public Packet createPacket() {
        return new ProducerInfo();
    }

    public void buildPacket(Packet packet, DataInput dataIn) throws IOException {
        super.buildPacket(packet, dataIn);
        ProducerInfo info = (ProducerInfo)packet;
        info.setProducerId(dataIn.readShort());
        info.setClientId(dataIn.readUTF());
        info.setSessionId(dataIn.readShort());
        info.setStartTime(dataIn.readLong());
        info.setStarted(dataIn.readBoolean());
        info.setDestination(ActiveMQDestination.readFromStream(dataIn));
    }
}

