/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.streams;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.activemq.message.ActiveMQBytesMessage;

public class JMSOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 16384;
    private byte[] buf;
    private int count;
    private boolean closed;
    private MessageProducer producer;

    public JMSOutputStream(MessageProducer producer) {
        this(producer, 16384);
    }

    public JMSOutputStream(MessageProducer producer, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
        this.producer = producer;
    }

    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.availableBufferToWrite() < 1) {
            this.flush();
        }
        this.buf[this.count++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (this.availableBufferToWrite() < len) {
            this.flush();
        }
        if (this.buf.length >= len) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        } else {
            this.writeBuffer(b, off, len);
        }
    }

    public void flush() throws IOException {
        this.checkClosed();
        if (this.count > 0) {
            this.writeBuffer(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.write(-1);
            this.flush();
            super.close();
            this.closed = true;
            try {
                this.producer.close();
            }
            catch (JMSException jmsEx) {
                IOException ioEx = new IOException(jmsEx.getMessage());
                throw ioEx;
            }
        }
    }

    protected void checkClosed() throws IOException {
        if (this.closed) {
            throw new EOFException("Cannot write to the stream any more it has already been closed");
        }
    }

    private int availableBufferToWrite() {
        return this.buf.length - this.count;
    }

    private void writeBuffer(byte[] buf, int offset, int length) throws IOException {
        try {
            ActiveMQBytesMessage message = new ActiveMQBytesMessage();
            message.writeBytes(buf, offset, length);
            this.producer.send((Message)message);
        }
        catch (JMSException jmsEx) {
            IOException ioEx = new IOException(jmsEx.getMessage());
            throw ioEx;
        }
    }
}

