/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.ConcurrentLayer;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;

public class ConcurrentLayerManager {
    private List subLayers = new ArrayList();
    private List activities = new ArrayList();

    public void initConcurrentLayer(List activities) {
        Hashtable<String, ConcurrentLayer> layers = new Hashtable<String, ConcurrentLayer>();
        Iterator it = activities.iterator();
        while (it.hasNext()) {
            ActivityElement act = (ActivityElement)it.next();
            if (!act.getType().equals("CONCUR_START")) continue;
            ConcurrentLayer l = new ConcurrentLayer();
            l.setStartElement(act);
            layers.put(act.getBlockID(), l);
        }
        Iterator it2 = activities.iterator();
        while (it2.hasNext()) {
            ActivityElement act = (ActivityElement)it2.next();
            if (act.getType().equals("CONCUR_START")) continue;
            if (act.getType().equals("CONCUR_END")) {
                ConcurrentLayer l = (ConcurrentLayer)layers.get(act.getBlockID());
                l.setEndElement(act);
                String parentID = act.getParentBID();
                if (StringUtils.checkNull(parentID)) {
                    this.addLayer(l);
                    continue;
                }
                ConcurrentLayer pl = (ConcurrentLayer)layers.get(parentID);
                l.setParentLayer(pl);
                pl.addLayer(l);
                continue;
            }
            String affID = act.getAffiliateBID();
            if (StringUtils.checkNull(affID)) continue;
            ConcurrentLayer al = (ConcurrentLayer)layers.get(affID);
            al.addLayerElement(act);
        }
    }

    public String getLayerID() {
        return null;
    }

    public void addLayerElement(ActivityElement elem) {
        if (elem == null) {
            return;
        }
        this.activities.add(elem);
    }

    public void removeLayerElement(ActivityElement elem) {
        if (elem == null) {
            return;
        }
        if (this.activities.contains(elem)) {
            this.activities.remove(elem);
        } else {
            Iterator it = this.subLayers.iterator();
            while (it.hasNext()) {
                ConcurrentLayer layer = (ConcurrentLayer)it.next();
                layer.removeLayerElement(elem);
            }
        }
    }

    public void addLayer(ConcurrentLayer layer) {
        if (layer == null) {
            return;
        }
        this.addLayerElement(layer.getStartElement());
        this.addLayerElement(layer.getEndElement());
        this.subLayers.add(layer);
    }

    public void removeLayer(ConcurrentLayer l) {
        if (l == null) {
            return;
        }
        if (this.subLayers.contains(l)) {
            this.removeLayerElement(l.getStartElement());
            this.removeLayerElement(l.getEndElement());
            l.clearParentLayer();
            this.subLayers.remove(l);
        } else {
            Iterator it = this.subLayers.iterator();
            while (it.hasNext()) {
                ConcurrentLayer layer = (ConcurrentLayer)it.next();
                layer.removeLayer(l);
            }
        }
    }

    public void collectAllLayerElement(List list) {
        Iterator lit = this.subLayers.iterator();
        while (lit.hasNext()) {
            ConcurrentLayer layer = (ConcurrentLayer)lit.next();
            layer.collectAllLayerElement(list);
        }
        Iterator ait = this.activities.iterator();
        while (ait.hasNext()) {
            ActivityElement act = (ActivityElement)ait.next();
            if (list.contains(act)) continue;
            list.add(act);
        }
    }

    public ConcurrentLayer getReceivableLayer(int lx, int ly) {
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ConcurrentLayer layer = ((ConcurrentLayer)it.next()).getReceivableLayer(lx, ly);
            if (layer == null) continue;
            return layer;
        }
        return null;
    }

    public ConcurrentLayer getContainLayer(ActivityElement elem) {
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ConcurrentLayer layer = ((ConcurrentLayer)it.next()).getContainLayer(elem);
            if (layer == null) continue;
            return layer;
        }
        return null;
    }

    public ActivityElement getStartElement() {
        return null;
    }

    public ActivityElement getEndElement() {
        return null;
    }

    public ConcurrentLayer getParentLayer() {
        return null;
    }

    public Point getMinimumUpperPoint() {
        int x = Integer.MAX_VALUE;
        int y = Integer.MAX_VALUE;
        return new Point(x, y);
    }

    public Point getMinimumLowerPoint() {
        int x = 0;
        int y = 0;
        return new Point(x, y);
    }

    public void paintLayerBackgroud(Graphics g, Color c, int grid) {
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ((ConcurrentLayer)it.next()).paintLayerBackgroud(g, c, grid);
        }
    }

    public void paintLayerBorder(Graphics g, Color c, int grid) {
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ((ConcurrentLayer)it.next()).paintLayerBorder(g, c, grid);
        }
    }
}

